/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.e4.locks;

import ch.elexis.core.lock.types.LockResponse;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.IElexisServerService;
import ch.elexis.core.services.holder.ElexisServerServiceHolder;
import ch.elexis.core.services.holder.LocalLockServiceHolder;
import ch.elexis.core.ui.e4.locks.ILockHandler;
import ch.elexis.core.ui.e4.locks.LockResponseHelper;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AcquireLockBlockingUi {
    private static Logger logger = LoggerFactory.getLogger(AcquireLockBlockingUi.class);

    public static void aquireAndRun(final Identifiable identifiable, final ILockHandler handler) {
        if (ElexisServerServiceHolder.get().getConnectionStatus() == IElexisServerService.ConnectionStatus.STANDALONE) {
            handler.lockAcquired();
            return;
        }
        final Display display = Display.getDefault();
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                ProgressMonitorDialog progress = new ProgressMonitorDialog(display.getActiveShell());
                try {
                    progress.run(true, true, (IRunnableWithProgress)new AcquireLockRunnable(identifiable, handler));
                }
                catch (InterruptedException | InvocationTargetException e) {
                    logger.warn("Exception during acquire lock.", (Throwable)e);
                }
            }
        });
    }

    private static class AcquireLockRunnable
    implements IRunnableWithProgress {
        private Identifiable lockIdentifiable;
        private ILockHandler lockhander;
        private LockResponse result;

        public AcquireLockRunnable(Identifiable lockIdentifiable, ILockHandler lockhander) {
            this.lockIdentifiable = lockIdentifiable;
            this.lockhander = lockhander;
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            this.result = LocalLockServiceHolder.get().acquireLockBlocking((Object)this.lockIdentifiable, 30, monitor);
            if (this.result != null) {
                Display display = Display.getDefault();
                if (this.result.isOk()) {
                    display.syncExec(new Runnable(){

                        @Override
                        public void run() {
                            lockhander.lockAcquired();
                        }
                    });
                    monitor.beginTask("Releasing lock ...", -1);
                    LocalLockServiceHolder.get().releaseLock(this.result.getLockInfo());
                    monitor.done();
                } else {
                    display.syncExec(new Runnable(){

                        @Override
                        public void run() {
                            lockhander.lockFailed();
                            LockResponseHelper.showInfo(result, lockIdentifiable, logger);
                        }
                    });
                }
            }
        }
    }
}

