/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.e4.dialog;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserDialog {
    private static Logger logger = LoggerFactory.getLogger(UserDialog.class);
    public final String title;
    public final String message;
    public final MessageType mt;
    public final IStatus status;

    public UserDialog(MessageType mt, String title, String message) {
        this(mt, title, message, null);
    }

    public UserDialog(MessageType mt, String title, String message, IStatus status) {
        this.title = title;
        this.message = message;
        this.mt = mt;
        this.status = status;
    }

    public boolean open() {
        Display display = Display.getDefault();
        UserDialogRunnable runnable = new UserDialogRunnable(display);
        display.syncExec((Runnable)runnable);
        return runnable.getResult();
    }

    public static void error(String title, String message) {
        UserDialog.open(MessageType.ERROR, title, message, null, null, false);
    }

    public static void error(String title, String message, Exception ex) {
        UserDialog.open(MessageType.ERROR, title, message, null, ex, false);
    }

    public static void loggedError(String title, String message) {
        UserDialog.open(MessageType.ERROR, title, message, null, null, true);
    }

    public static void loggedError(String title, String message, Exception ex) {
        UserDialog.open(MessageType.ERROR, title, message, null, ex, true);
    }

    public static void information(String title, String message) {
        UserDialog.open(MessageType.INFO, title, message, null, null, true);
    }

    public static boolean question(String title, String message) {
        return UserDialog.open(MessageType.QUESTION, title, message, null, null, true);
    }

    private static boolean open(MessageType mt, String title, String message, IStatus status, Exception ex, boolean log) {
        if (log) {
            String logMsg = title + " - " + message;
            switch (mt) {
                case ERROR: {
                    if (ex == null) {
                        logger.error(logMsg);
                        break;
                    }
                    logger.error(logMsg, (Throwable)ex);
                    break;
                }
                case WARN: {
                    if (ex == null) {
                        logger.warn(logMsg);
                        break;
                    }
                    logger.warn(logMsg, (Throwable)ex);
                    break;
                }
                case INFO: 
                case QUESTION: {
                    if (ex == null) {
                        logger.info(logMsg);
                        break;
                    }
                    logger.info(logMsg, (Throwable)ex);
                }
            }
        }
        return new UserDialog(mt, title, message, status).open();
    }

    public static enum MessageType {
        INFO,
        WARN,
        ERROR,
        QUESTION;

    }

    private class UserDialogRunnable
    implements Runnable {
        private boolean result = false;
        private final Display display;

        public UserDialogRunnable(Display display) {
            this.display = display;
        }

        @Override
        public void run() {
            logger.debug("MessageEvent [" + String.valueOf((Object)UserDialog.this.mt) + "]  [" + UserDialog.this.title + "] [" + UserDialog.this.message + "]");
            switch (UserDialog.this.mt) {
                case ERROR: {
                    MessageDialog.openError((Shell)this.display.getActiveShell(), (String)UserDialog.this.title, (String)UserDialog.this.message);
                    this.result = true;
                    break;
                }
                case WARN: {
                    MessageDialog.openWarning((Shell)this.display.getActiveShell(), (String)UserDialog.this.title, (String)UserDialog.this.message);
                    this.result = true;
                    break;
                }
                case QUESTION: {
                    this.result = MessageDialog.openQuestion((Shell)this.display.getActiveShell(), (String)UserDialog.this.title, (String)UserDialog.this.message);
                    break;
                }
                default: {
                    MessageDialog.openInformation((Shell)this.display.getActiveShell(), (String)UserDialog.this.title, (String)UserDialog.this.message);
                    this.result = true;
                }
            }
        }

        public boolean getResult() {
            return this.result;
        }
    }
}

