/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.e4.dialog;

import ch.elexis.core.model.IMandator;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class MandantSelectorDialog
extends TitleAreaDialog {
    private List<IMandator> mandatorsList;
    private ListViewer uiList;
    private List<IMandator> selMandators;
    private String idList;
    private boolean multi;
    private boolean noEmpty;
    private boolean nonActive;

    public MandantSelectorDialog(Shell parentShell, boolean multi, boolean noEmpty, boolean nonActive, String idList) {
        super(parentShell);
        this.multi = multi;
        this.noEmpty = noEmpty;
        this.nonActive = nonActive;
        this.idList = idList;
    }

    public MandantSelectorDialog(Shell parentShell, boolean multi) {
        this(parentShell, multi, true, false, null);
    }

    public MandantSelectorDialog(Shell parentShell, String idList) {
        this(parentShell, true, false, true, idList);
    }

    public Control createDialogArea(Composite parent) {
        Composite radioComposite = new Composite(parent, 0);
        radioComposite.setLayout((Layout)new GridLayout(2, false));
        Button btnAlle = new Button(radioComposite, 0);
        btnAlle.setText("alle");
        btnAlle.addListener(13, e -> this.uiList.getList().selectAll());
        Button btnKeine = new Button(radioComposite, 0);
        btnKeine.setText("keine");
        btnKeine.addListener(13, e -> this.uiList.getList().deselectAll());
        if (this.multi) {
            this.setTitle("Mandanten Auswahl");
            StringBuilder msg = new StringBuilder("Bitte w\u00e4hlen Sie die Mandanten aus.");
            if (this.noEmpty) {
                msg.append("\nKeine Auswahl selektiert den aktiven Mandanten");
            }
            this.setMessage(msg.toString());
            this.uiList = new ListViewer(parent, 2050);
        } else {
            this.setTitle("Mandant \u00e4ndern");
            this.setMessage("Bitte w\u00e4hlen Sie einen Mandanten");
            this.uiList = new ListViewer(parent, 2052);
        }
        this.mandatorsList = this.getMandators();
        this.uiList.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.uiList.setInput(this.mandatorsList);
        this.uiList.getList().setLayoutData((Object)new GridData(4, 4, true, true));
        this.uiList.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((IMandator)element).getLabel();
            }
        });
        this.setSelected(this.idList);
        return this.uiList.getList();
    }

    protected void okPressed() {
        this.selMandators = this.uiList.getStructuredSelection().toList();
        super.okPressed();
    }

    public IMandator getSelectedMandator() {
        if (this.selMandators.isEmpty()) {
            if (this.noEmpty) {
                return ContextServiceHolder.getActiveMandatorOrNull();
            }
            return null;
        }
        return this.selMandators.get(0);
    }

    public List<IMandator> getSelectedMandators() {
        return this.selMandators;
    }

    private List<IMandator> getMandators() {
        List mandators = CoreModelServiceHolder.get().getQuery(IMandator.class).execute();
        List<IMandator> list = mandators.stream().filter(m -> (this.nonActive || this.isActive((IMandator)m)) && this.isMandator((IMandator)m)).map(m -> m).collect(Collectors.toList());
        list.sort(Comparator.comparing(Identifiable::getLabel));
        return list;
    }

    public void setSelected(String idList) {
        if (idList == null || idList.isBlank()) {
            return;
        }
        this.uiList.setSelection((ISelection)new StructuredSelection(this.mandatorsList.stream().filter(m -> idList.contains(m.getId())).toList()));
    }

    private boolean isMandator(IMandator mandator) {
        return mandator != null && mandator.isMandator();
    }

    private boolean isActive(IMandator mandator) {
        return mandator != null && mandator.isActive();
    }
}

