/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.dbcheck.contributions;

import ch.elexis.core.model.IContact;
import ch.elexis.core.model.ICoverage;
import ch.elexis.core.model.IOrganization;
import ch.elexis.core.model.ISticker;
import ch.elexis.core.model.IXid;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.services.IQueryCursor;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.services.holder.StickerServiceHolder;
import ch.elexis.core.services.holder.XidServiceHolder;
import ch.elexis.core.ui.dbcheck.external.ExternalMaintenance;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;

public class XidsFromExtInfo
extends ExternalMaintenance {
    private ISticker insuranceSticker;

    @Override
    public String executeMaintenance(IProgressMonitor pm, String DBVersion) {
        this.insuranceSticker = CoreModelServiceHolder.get().load("managedinsurance", ISticker.class).orElse(null);
        StringBuilder sb = new StringBuilder();
        int withExtInfoEan = 0;
        int createdEanXid = 0;
        int alreadyEanXid = 0;
        int conflictEanXid = 0;
        IQuery organizationQuery = CoreModelServiceHolder.get().getQuery(IOrganization.class);
        Throwable throwable = null;
        Object var10_12 = null;
        try (IQueryCursor allOrganizations = organizationQuery.executeAsCursor();){
            StringBuilder conflictSb = new StringBuilder();
            while (allOrganizations.hasNext()) {
                IOrganization organization = (IOrganization)allOrganizations.next();
                Object extInfoEan = organization.getExtInfo((Object)"EAN");
                if (!(extInfoEan instanceof String) || !StringUtils.isNotBlank((CharSequence)((String)extInfoEan))) continue;
                ++withExtInfoEan;
                List found = XidServiceHolder.get().findObjects("www.xid.ch/id/ean", (String)extInfoEan, IOrganization.class);
                if (found.isEmpty()) {
                    organization.addXid("www.xid.ch/id/ean", (String)extInfoEan, false);
                    ++createdEanXid;
                    continue;
                }
                if (found.size() == 1) {
                    if (((IOrganization)found.get(0)).equals(organization)) {
                        ++alreadyEanXid;
                        continue;
                    }
                    ++conflictEanXid;
                    conflictSb.append("ExtInfo EAN [" + (String)extInfoEan + "] of org id [" + organization.getId() + "] found in xid of org id [" + ((IOrganization)found.get(0)).getId() + "]\n");
                    continue;
                }
                ++conflictEanXid;
                conflictSb.append("ExtInfo EAN [" + (String)extInfoEan + "] of org id [" + organization.getId() + "] found in xid of multi org ids [" + found.stream().map(o -> o.getId()).collect(Collectors.joining(",")) + "]\n");
            }
            sb.append("Organization EAN:\n");
            sb.append("found EAN ExtInfo " + withExtInfoEan + "\n");
            sb.append("created EAN XID " + createdEanXid + "\n");
            sb.append("already EAN XID " + alreadyEanXid + "\n");
            sb.append("conflict EAN XID " + conflictEanXid + "\n");
            if (conflictEanXid > 0) {
                sb.append(conflictSb.toString());
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        if (this.insuranceSticker != null) {
            int coverageNoRefOrOrg = 0;
            int coverageNoEanContact = 0;
            int coverageNoManagedContact = 0;
            int coverageManagedContact = 0;
            int coverageChangedToManagedContact = 0;
            IQuery coverageQuery = CoreModelServiceHolder.get().getQuery(ICoverage.class);
            Throwable throwable3 = null;
            Object var16_24 = null;
            try (IQueryCursor allCoverages = coverageQuery.executeAsCursor();){
                while (allCoverages.hasNext()) {
                    Optional<IOrganization> managedInsurance;
                    Optional<String> ean;
                    ICoverage coverage = (ICoverage)allCoverages.next();
                    if (coverage.getCostBearer() != null && coverage.getCostBearer().isOrganization()) {
                        ean = this.getEAN(coverage.getCostBearer());
                        if (ean.isPresent()) {
                            if (!StickerServiceHolder.get().hasSticker((Identifiable)coverage.getCostBearer(), this.insuranceSticker)) {
                                managedInsurance = this.getManagedInsuranceWithEan(ean.get());
                                if (managedInsurance.isPresent()) {
                                    coverage.setCostBearer((IContact)managedInsurance.get());
                                    ++coverageChangedToManagedContact;
                                } else {
                                    ++coverageNoManagedContact;
                                }
                            } else {
                                ++coverageManagedContact;
                            }
                        } else {
                            ++coverageNoEanContact;
                        }
                    } else {
                        ++coverageNoRefOrOrg;
                    }
                    if (coverage.getGuarantor() != null && coverage.getGuarantor().isOrganization()) {
                        ean = this.getEAN(coverage.getGuarantor());
                        if (ean.isPresent()) {
                            if (!StickerServiceHolder.get().hasSticker((Identifiable)coverage.getGuarantor(), this.insuranceSticker)) {
                                managedInsurance = this.getManagedInsuranceWithEan(ean.get());
                                if (managedInsurance.isPresent()) {
                                    coverage.setGuarantor((IContact)managedInsurance.get());
                                    ++coverageChangedToManagedContact;
                                    continue;
                                }
                                ++coverageNoManagedContact;
                                continue;
                            }
                            ++coverageManagedContact;
                            continue;
                        }
                        ++coverageNoEanContact;
                        continue;
                    }
                    ++coverageNoRefOrOrg;
                }
            }
            catch (Throwable throwable4) {
                if (throwable3 == null) {
                    throwable3 = throwable4;
                } else if (throwable3 != throwable4) {
                    throwable3.addSuppressed(throwable4);
                }
                throw throwable3;
            }
            sb.append("\nCoverage managedinsurance:");
            sb.append("\nReferences missing or no org:" + coverageNoRefOrOrg);
            sb.append("\nReferences to org no ean:" + coverageNoEanContact);
            sb.append("\nReferences to managedinsurances:" + coverageManagedContact);
            sb.append("\nReferences to not managedinsurances:" + coverageNoManagedContact);
            sb.append("\nChanged References managedinsurances:" + coverageChangedToManagedContact);
        } else {
            sb.append("\nNo managedinsurance sticker\n");
        }
        return sb.toString();
    }

    private Optional<IOrganization> getManagedInsuranceWithEan(String ean) {
        List found = XidServiceHolder.get().findObjects("www.xid.ch/id/ean", ean, IOrganization.class);
        if (found != null && !found.isEmpty()) {
            for (IOrganization iOrganization : found) {
                if (!StickerServiceHolder.get().hasSticker((Identifiable)iOrganization, this.insuranceSticker)) continue;
                return Optional.of(iOrganization);
            }
        }
        return Optional.empty();
    }

    private Optional<String> getEAN(IContact contact) {
        IXid xid = contact.getXid("www.xid.ch/id/ean");
        if (xid != null && StringUtils.isNotBlank((CharSequence)xid.getDomainId())) {
            return Optional.of(xid.getDomainId());
        }
        return Optional.empty();
    }

    @Override
    public String getMaintenanceDescription() {
        return "XIDs aus ExtInfo Informationen erstellen (z.B. EAN)";
    }
}

