/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.dbcheck.contributions;

import ch.elexis.core.data.util.NoPoUtil;
import ch.elexis.core.model.IBillable;
import ch.elexis.core.model.IBillableOptifier;
import ch.elexis.core.model.IBilled;
import ch.elexis.core.model.IBillingSystemFactor;
import ch.elexis.core.model.ICoverage;
import ch.elexis.core.model.IEncounter;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.IBilledAdjuster;
import ch.elexis.core.services.ICodeElementService;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.ui.dbcheck.external.ExternalMaintenance;
import ch.elexis.data.Konsultation;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Query;
import ch.rgw.tools.TimeTool;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.slf4j.LoggerFactory;

public class SetAmbulatoryFactorOpenCons
extends ExternalMaintenance {
    private List<String> problems = new ArrayList<String>();
    protected ICodeElementService codeElementService;
    private ServiceReference<ICodeElementService> serviceRef;
    protected IBilledAdjuster vatAdjuster;
    private List<ServiceReference<IBilledAdjuster>> vatServiceRef;
    private boolean currentMandantOnly;

    @Override
    public String executeMaintenance(IProgressMonitor pm, String DBVersion) {
        Integer count = 0;
        if (this.initCodeElementService()) {
            this.initVatAdjuster();
            this.getCurrentMandantOnly();
            boolean presetBillingStrict = ConfigServiceHolder.getUser((String)"billing/strict", (boolean)false);
            ConfigServiceHolder.setUser((String)"billing/strict", (boolean)false);
            List<Konsultation> consultations = this.getKonsultation(this.getBeginOfYear(), this.getEndOfYear());
            pm.beginTask("Bitte warten, Taxpunktwert und MWSt Info Ambulantepauschalen werden neu gesetzt", consultations.size());
            for (Konsultation konsultation : consultations) {
                if (konsultation.getRechnung() != null) continue;
                IEncounter encounter = (IEncounter)NoPoUtil.loadAsIdentifiable((PersistentObject)konsultation, IEncounter.class).get();
                if (pm.isCanceled()) {
                    this.addProblem("Cancelled.", encounter);
                    return this.getProblemsString();
                }
                List<IBilled> ambulatoryVerrechnet = this.getAmbulatoryOnly(encounter.getBilled());
                for (IBilled ambulatoryVerr : ambulatoryVerrechnet) {
                    IBillable verrechenbar = ambulatoryVerr.getBillable();
                    if (verrechenbar != null) {
                        Optional matchingVerrechenbar = this.codeElementService.loadFromString(verrechenbar.getCodeSystemName(), verrechenbar.getCode(), this.getContext(encounter));
                        if (matchingVerrechenbar.isPresent()) {
                            IBillableOptifier optifier;
                            Optional factor;
                            if (this.vatAdjuster != null) {
                                this.vatAdjuster.adjust(ambulatoryVerr);
                            }
                            if (!(factor = (optifier = verrechenbar.getOptifier()).getFactor(encounter)).isPresent()) continue;
                            ambulatoryVerr.setFactor(((IBillingSystemFactor)factor.get()).getFactor());
                            CoreModelServiceHolder.get().save((Identifiable)ambulatoryVerr);
                            continue;
                        }
                        this.addProblem("Could not find matching Verrechenbar for [" + verrechenbar.getCodeSystemName() + "->" + verrechenbar.getCode() + "]", encounter);
                        continue;
                    }
                    this.addProblem("Could not find Verrechenbar for [" + ambulatoryVerr.getLabel() + "]", encounter);
                }
                count = count + 1;
                pm.worked(1);
            }
            ConfigServiceHolder.setUser((String)"billing/strict", (boolean)presetBillingStrict);
            pm.done();
            this.deInitCodeElementService();
            this.deInitVatAdjuster();
        }
        return "Ambulantepauschalen von [" + String.valueOf(count) + "] Konsultationen des Jahres [" + this.getBeginOfYear().get(1) + "] neuer Taxpunktwet gesetzt" + this.getProblemsString();
    }

    private void getCurrentMandantOnly() {
        Display.getDefault().syncExec(() -> {
            this.currentMandantOnly = MessageDialog.openQuestion((Shell)Display.getDefault().getActiveShell(), (String)"Nur Ambulantepauschalen des Mandant neu setzen", (String)"Sollen bei offenen Konsultationen aller Mandanten (Nein), oder nur des aktiven (Ja) die Ambulantenpauschalen neu gesetzt werden?");
        });
    }

    protected TimeTool getBeginOfYear() {
        TimeTool beginOfYear = new TimeTool();
        beginOfYear.set(2, 0);
        beginOfYear.set(5, 1);
        return beginOfYear;
    }

    protected TimeTool getEndOfYear() {
        TimeTool endOfYear = this.getBeginOfYear();
        endOfYear.set(2, 11);
        endOfYear.set(5, 31);
        return endOfYear;
    }

    private HashMap<Object, Object> getContext(IEncounter encounter) {
        HashMap<Object, Object> ret = new HashMap<Object, Object>();
        if (encounter != null) {
            ret.put(ICodeElementService.ContextKeys.CONSULTATION, encounter);
            ICoverage coverage = encounter.getCoverage();
            if (coverage != null) {
                ret.put(ICodeElementService.ContextKeys.COVERAGE, coverage);
            }
        }
        return ret;
    }

    private void deInitCodeElementService() {
        BundleContext context = FrameworkUtil.getBundle(SetAmbulatoryFactorOpenCons.class).getBundleContext();
        if (this.serviceRef != null) {
            context.ungetService(this.serviceRef);
            this.codeElementService = null;
        }
    }

    private boolean initCodeElementService() {
        BundleContext context = FrameworkUtil.getBundle(SetAmbulatoryFactorOpenCons.class).getBundleContext();
        this.serviceRef = context.getServiceReference(ICodeElementService.class);
        if (this.serviceRef != null) {
            this.codeElementService = (ICodeElementService)context.getService(this.serviceRef);
            return true;
        }
        return false;
    }

    private void deInitVatAdjuster() {
        BundleContext context = FrameworkUtil.getBundle(SetAmbulatoryFactorOpenCons.class).getBundleContext();
        if (this.vatServiceRef != null && !this.vatServiceRef.isEmpty()) {
            context.ungetService(this.vatServiceRef.get(0));
            this.vatAdjuster = null;
        }
    }

    private void initVatAdjuster() {
        try {
            BundleContext context = FrameworkUtil.getBundle(SetAmbulatoryFactorOpenCons.class).getBundleContext();
            this.vatServiceRef = new ArrayList<ServiceReference<IBilledAdjuster>>(context.getServiceReferences(IBilledAdjuster.class, "(id=VatVerrechnetAdjuster)"));
            if (this.vatServiceRef != null && !this.vatServiceRef.isEmpty()) {
                this.vatAdjuster = (IBilledAdjuster)context.getService(this.vatServiceRef.get(0));
            }
        }
        catch (InvalidSyntaxException e) {
            LoggerFactory.getLogger(this.getClass()).error("Error getting vat adjuster");
        }
    }

    private List<IBilled> getAmbulatoryOnly(List<IBilled> list) {
        ArrayList<IBilled> ret = new ArrayList<IBilled>();
        for (IBilled verrechnet : list) {
            IBillable billable = verrechnet.getBillable();
            if (!billable.getCodeSystemName().contains("Ambulantepauschalen")) continue;
            ret.add(verrechnet);
        }
        return ret;
    }

    public List<Konsultation> getKonsultation(TimeTool from, TimeTool to) {
        Query qbe = new Query(Konsultation.class);
        qbe.add("Datum", ">=", from.toString(9));
        if (to != null) {
            qbe.add("Datum", "<=", to.toString(9));
        }
        if (this.currentMandantOnly) {
            qbe.add("MandantID", "=", ContextServiceHolder.getActiveMandatorOrNull().getId());
        }
        return qbe.execute();
    }

    private String getProblemsString() {
        if (this.problems != null && !this.problems.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("\nProblems:\n");
            this.problems.stream().forEach(problem -> {
                StringBuilder stringBuilder2 = sb.append(problem + "\n");
            });
            return sb.toString();
        }
        return "";
    }

    private void addProblem(String prefix, IEncounter cons) {
        this.problems.add("[" + prefix + "][" + cons.getId() + "] - [" + cons.getLabel() + "] of [" + cons.getPatient().getLabel() + "]");
    }

    @Override
    public String getMaintenanceDescription() {
        return "Taxpunktwert und MWSt Info Ambulanterpauschalen aller offenen Konsultationen dieses Jahres neu setzen";
    }
}

