/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.dbcheck.contributions;

import ch.elexis.core.model.IInvoice;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.services.IQueryCursor;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.ui.dbcheck.external.ExternalMaintenance;
import ch.rgw.tools.Money;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

public class FixInvoiceRoundedAmount
extends ExternalMaintenance {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String executeMaintenance(IProgressMonitor pm, String DBVersion) {
        IQuery invoicesQuery = CoreModelServiceHolder.get().getQuery(IInvoice.class);
        int counter = 0;
        Throwable throwable = null;
        Object var6_7 = null;
        try (IQueryCursor cursor = invoicesQuery.executeAsCursor();){
            pm.beginTask("Bitte warten, der Betrag aller Rechnungen wird \u00fcberpr\u00fcft", cursor.size());
            do {
                if (!cursor.hasNext()) {
                    return "Betrag von " + counter + " Rechnungen korrigiert";
                }
                IInvoice invoice = (IInvoice)cursor.next();
                List outputs = invoice.getTrace("Ausgegeben");
                if (!outputs.isEmpty()) {
                    Money openAmount = invoice.getOpenAmount();
                    Money totalAmount = invoice.getTotalAmount();
                    if (!openAmount.isZero() && Math.abs(openAmount.getCents()) < 5 && Math.abs(new Money(totalAmount).roundTo5().getCents()) - Math.abs(totalAmount.getCents()) != 0) {
                        invoice.setTotalAmount(totalAmount.roundTo5());
                        CoreModelServiceHolder.get().save((Identifiable)invoice);
                        ++counter;
                    }
                }
                pm.worked(1);
            } while (!pm.isCanceled());
            return "Abgebrochen ...";
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
                throw throwable;
            }
            if (throwable == throwable2) throw throwable;
            throwable.addSuppressed(throwable2);
            throw throwable;
        }
    }

    @Override
    public String getMaintenanceDescription() {
        return "Rundung des Betrags bei bezahlten Rechnungen korrigieren";
    }
}

