/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.dbcheck.cleaning;

import ch.elexis.core.ui.dbcheck.CheckExec;
import ch.elexis.core.ui.dbcheck.cleaning.CleaningCheck;
import ch.elexis.core.ui.dbcheck.model.DBModel;
import ch.elexis.core.ui.dbcheck.model.TableDescriptor;
import ch.rgw.tools.JdbcLink;

public class CleaningCheckPGSQL
extends CleaningCheck {
    public CleaningCheckPGSQL() {
        this.oklog = new StringBuilder();
        this.errlog = new StringBuilder();
    }

    @Override
    public String cleanCoreTables(JdbcLink j) {
        String version = CheckExec.getDBVersion();
        String[] tables = DBModel.getTableModel(version);
        int i = 0;
        while (i < tables.length) {
            TableDescriptor tableDetail = DBModel.getTableDescription(tables[i]);
            String[] cleaningScripts = tableDetail.getCleaningSQLforPostgresSQL(version);
            if (cleaningScripts != null && cleaningScripts.length > 0) {
                int k = 0;
                while (k < cleaningScripts.length) {
                    String description = cleaningScripts[k];
                    String query = cleaningScripts[k + 1];
                    JdbcLink.Stm stm = j.getStatement();
                    int rsNo = stm.exec(query);
                    if (rsNo > 1) {
                        this.errlog.append(tables[i] + ": " + description + " - # affected rows: " + rsNo);
                    }
                    this.oklog.append(tables[i] + ": " + description + " - # affected rows: " + rsNo);
                    k += 2;
                }
            }
            ++i;
        }
        return this.oklog.toString();
    }
}

