/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.spotlight.ui.command;

import ch.elexis.core.services.IContextService;
import ch.elexis.core.spotlight.ISpotlightService;
import ch.elexis.core.spotlight.ui.internal.ISpotlightResultEntryDetailCompositeService;
import ch.elexis.core.spotlight.ui.internal.SpotlightShell;
import ch.elexis.core.spotlight.ui.internal.ready.SpotlightReadyService;
import jakarta.inject.Named;
import java.util.HashMap;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;

public class OpenSpotlightShellHandler {
    @Execute
    public void execute(@Named(value="activeShell") Shell shell, ParameterizedCommand command, EPartService partService, IContextService contextService, ISpotlightService spotlightService, SpotlightReadyService spotlightReadyService, ISpotlightResultEntryDetailCompositeService resultEntryDetailCompositeService) {
        HashMap<String, String> spotlightContextParameters = null;
        String filter = (String)command.getParameterMap().get("ch.elexis.core.spotlight.ui.commandparameter.spotlightshellfilter");
        if (filter != null) {
            String patientId;
            spotlightContextParameters = new HashMap<String, String>();
            if ("patientFiltered".equals(filter) && (patientId = (String)contextService.getActivePatient().map(p -> p.getId()).orElse(null)) != null) {
                spotlightContextParameters.put("patientId", patientId);
            }
        }
        SpotlightShell spotlightShell = new SpotlightShell(shell, partService, spotlightService, resultEntryDetailCompositeService, spotlightReadyService, spotlightContextParameters);
        Monitor primary = spotlightShell.getDisplay().getPrimaryMonitor();
        Rectangle bounds = primary.getBounds();
        Rectangle rect = spotlightShell.getBounds();
        int x = bounds.x + (bounds.width - rect.width) / 2;
        int y = bounds.y + (bounds.height - rect.height) / 2;
        spotlightShell.setLocation(x, y -= 100);
        spotlightShell.open();
    }

    public static Region createRoundedRectangle(int x, int y, int W, int H, int r) {
        Region region = new Region();
        int d = 2 * r;
        region.add(OpenSpotlightShellHandler.circle(r, x + r, y + r));
        region.add(OpenSpotlightShellHandler.circle(r, x + W - r, y + r));
        region.add(OpenSpotlightShellHandler.circle(r, x + W - r, y + H - r));
        region.add(OpenSpotlightShellHandler.circle(r, x + r, y + H - r));
        region.add(x + r, y, W - d, H);
        region.add(x, y + r, W, H - d);
        return region;
    }

    public static int[] circle(int r, int offsetX, int offsetY) {
        int[] polygon = new int[8 * r + 4];
        int i = 0;
        while (i < 2 * r + 1) {
            int x = i - r;
            int y = (int)Math.sqrt(r * r - x * x);
            polygon[2 * i] = offsetX + x;
            polygon[2 * i + 1] = offsetY + y;
            polygon[8 * r - 2 * i - 2] = offsetX + x;
            polygon[8 * r - 2 * i - 1] = offsetY - y;
            ++i;
        }
        return polygon;
    }
}

