/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.services.oauth2;

import ch.elexis.core.eenv.AccessToken;
import ch.elexis.core.services.oauth2.AccessTokenUtil;
import ch.elexis.core.services.oauth2.KeycloakAccessTokenResponse;
import ch.elexis.core.services.oauth2.KeycloakOAuth2DeviceAuthorizationResponse;
import ch.elexis.core.status.ObjectStatus;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.function.Consumer;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.entity.UrlEncodedFormEntity;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.message.BasicNameValuePair;

public class OAuth2Service {
    private Gson gson = new GsonBuilder().create();

    public ObjectStatus<AccessToken> performDirectAccessGrantFlow(URI keycloakRealmEndpoint, String clientId, String clientSecret, String username, char[] password) {
        URI tokenEndpoint = keycloakRealmEndpoint.resolve("protocol/openid-connect/token");
        HttpPost httpPost = new HttpPost(tokenEndpoint);
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
        params.add(new BasicNameValuePair("grant_type", "password"));
        params.add(new BasicNameValuePair("client_id", clientId));
        params.add(new BasicNameValuePair("client_secret", clientSecret));
        params.add(new BasicNameValuePair("username", username));
        params.add(new BasicNameValuePair("password", String.valueOf(password)));
        httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(params));
        try {
            Throwable throwable = null;
            Object var10_12 = null;
            try (CloseableHttpClient client = HttpClients.createDefault();){
                return (ObjectStatus)client.execute((ClassicHttpRequest)httpPost, res -> {
                    if (res.getCode() == 200) {
                        HttpEntity entity = res.getEntity();
                        String accessTokenResponse = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
                        KeycloakAccessTokenResponse kcAccessTokenResponse = (KeycloakAccessTokenResponse)this.gson.fromJson(accessTokenResponse, KeycloakAccessTokenResponse.class);
                        AccessToken accessToken = AccessTokenUtil.load(kcAccessTokenResponse, tokenEndpoint.toString(), clientId);
                        return ObjectStatus.OK((Object)accessToken);
                    }
                    return ObjectStatus.ERROR((String)(res.getCode() + " " + res.getReasonPhrase()));
                });
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            return ObjectStatus.ERROR((String)e.getMessage());
        }
    }

    public ObjectStatus<AccessToken> performDeviceAuthorizationFlow(URI keycloakRealmEndpoint, String clientId, String clientSecret, Consumer<URI> verificationUrlCaller) {
        HttpPost httpPost = new HttpPost(keycloakRealmEndpoint.resolve("protocol/openid-connect/auth/device"));
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
        params.add(new BasicNameValuePair("client_id", clientId));
        params.add(new BasicNameValuePair("client_secret", clientSecret));
        httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(params));
        try {
            Throwable throwable = null;
            Object var8_10 = null;
            try (CloseableHttpClient client = HttpClients.createDefault();){
                ObjectStatus oAuth2DeviceAuthorizationResponseStatus = (ObjectStatus)client.execute((ClassicHttpRequest)httpPost, res -> {
                    if (res.getCode() == 200) {
                        HttpEntity entity = res.getEntity();
                        String jwt = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
                        KeycloakOAuth2DeviceAuthorizationResponse response = (KeycloakOAuth2DeviceAuthorizationResponse)this.gson.fromJson(jwt, KeycloakOAuth2DeviceAuthorizationResponse.class);
                        return ObjectStatus.OK((Object)response);
                    }
                    return ObjectStatus.ERROR((String)(res.getCode() + " " + res.getReasonPhrase()));
                });
                if (!oAuth2DeviceAuthorizationResponseStatus.isOK()) {
                    return ObjectStatus.ERROR((String)oAuth2DeviceAuthorizationResponseStatus.getMessage());
                }
                KeycloakOAuth2DeviceAuthorizationResponse keycloakOAuth2DeviceAuthorizationResponse = (KeycloakOAuth2DeviceAuthorizationResponse)oAuth2DeviceAuthorizationResponseStatus.get();
                String deviceCode = keycloakOAuth2DeviceAuthorizationResponse.getDeviceCode();
                String verificationUriComplete = keycloakOAuth2DeviceAuthorizationResponse.getVerificationUriComplete();
                verificationUrlCaller.accept(URI.create(verificationUriComplete));
                URI tokenEndpoint = keycloakRealmEndpoint.resolve("protocol/openid-connect/token");
                int i = 0;
                while (i < 15) {
                    Thread.sleep(2000L);
                    ObjectStatus<AccessToken> status = this.performDeviceAuthorizationFlowPollCall(tokenEndpoint, client, deviceCode, clientId, clientSecret);
                    if (status.isOK()) {
                        return ObjectStatus.OK((Object)((AccessToken)status.get()));
                    }
                    ++i;
                }
                return ObjectStatus.ERROR((String)"No token received after 30 seconds");
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | InterruptedException e) {
            return ObjectStatus.ERROR((String)e.getMessage());
        }
    }

    private ObjectStatus<AccessToken> performDeviceAuthorizationFlowPollCall(URI tokenEndpoint, CloseableHttpClient client, String deviceCode, String clientId, String clientSecret) throws IOException {
        HttpPost httpPost = new HttpPost(tokenEndpoint);
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
        params.add(new BasicNameValuePair("device_code", deviceCode));
        params.add(new BasicNameValuePair("grant_type", "urn:ietf:params:oauth:grant-type:device_code"));
        params.add(new BasicNameValuePair("client_id", clientId));
        params.add(new BasicNameValuePair("client_secret", clientSecret));
        httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(params));
        return (ObjectStatus)client.execute((ClassicHttpRequest)httpPost, res -> {
            if (res.getCode() == 200) {
                HttpEntity entity = res.getEntity();
                String accessTokenResponse = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
                KeycloakAccessTokenResponse kcAccessTokenResponse = (KeycloakAccessTokenResponse)this.gson.fromJson(accessTokenResponse, KeycloakAccessTokenResponse.class);
                AccessToken accessToken = AccessTokenUtil.load(kcAccessTokenResponse, tokenEndpoint.toString(), clientId);
                return ObjectStatus.OK((Object)accessToken);
            }
            return ObjectStatus.INFO((String)res.getReasonPhrase());
        });
    }
}

