/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.services.oauth2;

import ch.elexis.core.eenv.AccessToken;
import ch.elexis.core.services.oauth2.KeycloakAccessTokenResponse;
import ch.elexis.core.status.ObjectStatus;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.entity.UrlEncodedFormEntity;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.message.BasicNameValuePair;

public class AccessTokenUtil {
    public static AccessToken load(KeycloakAccessTokenResponse obtainAccessToken) {
        return AccessTokenUtil.load(obtainAccessToken, null, null);
    }

    public static AccessToken load(KeycloakAccessTokenResponse obtainAccessToken, String tokenEndpoint, String clientId) {
        Gson gson = new Gson();
        String accessToken = obtainAccessToken.getToken();
        String[] accessTokenParts = accessToken.split("\\.");
        JsonObject payload = (JsonObject)gson.fromJson(AccessTokenUtil.decode(accessTokenParts[1]), JsonObject.class);
        long accessTokenExp = payload.get("exp").getAsLong();
        Date accessTokenExpirationTime = new Date(accessTokenExp * 1000L);
        String username = payload.get("preferred_username").getAsString();
        String refreshToken = obtainAccessToken.getRefreshToken();
        Date refreshTokenExpirationDate = null;
        if (refreshToken != null) {
            String[] refreshTokenParts = refreshToken.split("\\.");
            JsonObject refreshTokenPayload = (JsonObject)gson.fromJson(AccessTokenUtil.decode(refreshTokenParts[1]), JsonObject.class);
            long refreshTokenExp = refreshTokenPayload.get("exp").getAsLong();
            refreshTokenExpirationDate = new Date(refreshTokenExp * 1000L);
        }
        AccessToken keycloakAccessToken = new AccessToken(accessToken, accessTokenExpirationTime, username, refreshToken, refreshTokenExpirationDate, tokenEndpoint, clientId);
        return keycloakAccessToken;
    }

    public static ObjectStatus<AccessToken> invokeRefresh(AccessToken accessToken, String clientSecret) {
        String tokenEndpoint = accessToken.getTokenEndpoint();
        if (tokenEndpoint != null) {
            HttpPost httpPost = new HttpPost(tokenEndpoint);
            ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
            params.add(new BasicNameValuePair("grant_type", "refresh_token"));
            params.add(new BasicNameValuePair("client_id", accessToken.getClientId()));
            if (StringUtils.isNotBlank((CharSequence)clientSecret)) {
                params.add(new BasicNameValuePair("client_secret", clientSecret));
            }
            params.add(new BasicNameValuePair("refresh_token", accessToken.getRefreshToken()));
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(params));
            try {
                Throwable throwable = null;
                Object var6_8 = null;
                try (CloseableHttpClient client = HttpClients.createDefault();){
                    return (ObjectStatus)client.execute((ClassicHttpRequest)httpPost, res -> {
                        if (res.getCode() == 200) {
                            HttpEntity entity = res.getEntity();
                            String accessTokenResponse = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
                            KeycloakAccessTokenResponse kcAccessTokenResponse = (KeycloakAccessTokenResponse)new Gson().fromJson(accessTokenResponse, KeycloakAccessTokenResponse.class);
                            AccessToken _accessToken = AccessTokenUtil.load(kcAccessTokenResponse, tokenEndpoint, accessToken.getClientId());
                            return ObjectStatus.OK((Object)_accessToken);
                        }
                        return ObjectStatus.ERROR((String)(res.getCode() + " " + res.getReasonPhrase()));
                    });
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                return ObjectStatus.ERROR((String)e.getMessage());
            }
        }
        return ObjectStatus.ERROR((String)"No token endpoint defined in existing access token");
    }

    private static String decode(String encodedString) {
        return new String(Base64.getUrlDecoder().decode(encodedString));
    }
}

