/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.services.internal.text;

import ch.elexis.core.interfaces.ILocalizedEnum;
import ch.elexis.core.model.IEncounter;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.IContext;
import ch.elexis.core.text.ITextPlaceholderResolver;
import ch.elexis.core.text.PlaceholderAttribute;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.osgi.service.component.annotations.Component;

@Component
public class EncounterTextPlaceholderResolver
implements ITextPlaceholderResolver {
    public String getSupportedType() {
        return "Konsultation";
    }

    public List<PlaceholderAttribute> getSupportedAttributes() {
        return Arrays.asList(KonsultationAttribute.values()).stream().map(m -> new PlaceholderAttribute(this.getSupportedType(), m.name(), m.getLocaleText())).collect(Collectors.toList());
    }

    public Optional<String> replaceByTypeAndAttribute(IContext context, String attribute) {
        IEncounter encounter = this.getIdentifiable(context).orElse(null);
        if (encounter != null) {
            return Optional.ofNullable(this.replace(encounter, attribute.toLowerCase()));
        }
        return Optional.empty();
    }

    public Optional<? extends Identifiable> getIdentifiable(IContext context) {
        Optional ret = context.getTyped(IEncounter.class);
        if (ret.isEmpty()) {
            ret = context.getNamed(this.getSupportedType());
        }
        return ret;
    }

    private String replace(IEncounter encounter, String lcAttribute) {
        KonsultationAttribute attribute = (KonsultationAttribute)this.searchEnum(KonsultationAttribute.class, lcAttribute);
        switch (attribute) {
            case Eintrag: {
                return encounter.getHeadVersionInPlaintext();
            }
        }
        return null;
    }

    private static enum KonsultationAttribute implements ILocalizedEnum
    {
        Eintrag("Text der Konsultation");

        final String description;

        private KonsultationAttribute(String description) {
            this.description = description;
        }

        public String getLocaleText() {
            return this.description;
        }
    }
}

