/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.services.internal.text;

import ch.elexis.core.interfaces.ILocalizedEnum;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.IContext;
import ch.elexis.core.text.ITextPlaceholderResolver;
import ch.elexis.core.text.PlaceholderAttribute;
import ch.elexis.core.time.TimeUtil;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.osgi.service.component.annotations.Component;

@Component
public class DatumTextPlaceholderResolver
implements ITextPlaceholderResolver {
    public String getSupportedType() {
        return "Datum";
    }

    public List<PlaceholderAttribute> getSupportedAttributes() {
        return Arrays.asList(DatumAttribute.values()).stream().map(m -> new PlaceholderAttribute(this.getSupportedType(), m.name(), m.getLocaleText())).collect(Collectors.toList());
    }

    public Optional<String> replaceByTypeAndAttribute(IContext context, String attribute) {
        return Optional.ofNullable(this.replace(attribute.toLowerCase()));
    }

    public Optional<? extends Identifiable> getIdentifiable(IContext context) {
        return Optional.empty();
    }

    private String replace(String lcAttribute) {
        DatumAttribute datumAttribut = (DatumAttribute)this.searchEnum(DatumAttribute.class, lcAttribute);
        if (datumAttribut != null) {
            switch (datumAttribut) {
                case Heute: {
                    return TimeUtil.DATE_GER.format(LocalDate.now());
                }
            }
        }
        return null;
    }

    private static enum DatumAttribute implements ILocalizedEnum,
    ITextPlaceholderResolver.IPlaceholderAttributeEnum
    {
        Heute("Datum Heute", new String[]{"Datum"});

        final String description;
        private String[] alternativeNames;

        private DatumAttribute(String description) {
            this.description = description;
        }

        private DatumAttribute(String description, String[] alternativeNames) {
            this.description = description;
            this.alternativeNames = alternativeNames;
        }

        public String getLocaleText() {
            return this.description;
        }

        public List<String> getAlternativeNames() {
            return this.alternativeNames != null ? Arrays.asList(this.alternativeNames) : Collections.emptyList();
        }
    }
}

