/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.services.internal.text;

import ch.elexis.core.interfaces.ILocalizedEnum;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.format.AddressFormatUtil;
import ch.elexis.core.services.IContext;
import ch.elexis.core.text.ITextPlaceholderResolver;
import ch.elexis.core.text.PlaceholderAttribute;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.osgi.service.component.annotations.Component;

@Component(property={"type=Kontakt"})
public class ContactTextPlaceholderResolver
implements ITextPlaceholderResolver {
    public String getSupportedType() {
        return "Kontakt";
    }

    public List<PlaceholderAttribute> getSupportedAttributes() {
        return Arrays.asList(ContactAttribute.values()).stream().map(m -> new PlaceholderAttribute(this.getSupportedType(), m.name(), m.getLocaleText())).collect(Collectors.toList());
    }

    public Optional<String> replaceByTypeAndAttribute(IContext context, String attribute) {
        IContact contact = this.getIdentifiable(context).orElse(null);
        if (contact != null) {
            return Optional.ofNullable(this.replace(contact, attribute.toLowerCase()));
        }
        return Optional.empty();
    }

    public Optional<? extends Identifiable> getIdentifiable(IContext context) {
        return context.getTyped(IContact.class);
    }

    private String replace(IContact contact, String lcAttribute) {
        ContactAttribute contactAttribut = (ContactAttribute)this.searchEnum(ContactAttribute.class, lcAttribute);
        if (contactAttribut != null) {
            switch (contactAttribut) {
                case Name: {
                    StringBuilder sb = new StringBuilder();
                    sb.append(contact.getDescription1()).append(" ").append(StringUtils.defaultString((String)contact.getDescription2()));
                    if (!StringUtils.isBlank((CharSequence)contact.getDescription3())) {
                        sb.append("(").append(contact.getDescription3()).append(")");
                    }
                }
                case Anschrift: {
                    return AddressFormatUtil.getPostalAddress((IContact)contact, (boolean)true);
                }
                case Anschriftzeile: {
                    return AddressFormatUtil.getPostalAddress((IContact)contact, (boolean)false);
                }
                case Strasse: {
                    return StringUtils.defaultString((String)contact.getStreet());
                }
                case Plz: {
                    return StringUtils.defaultString((String)contact.getZip());
                }
                case Ort: {
                    return StringUtils.defaultString((String)contact.getCity());
                }
                case Telefon1: {
                    return StringUtils.defaultString((String)contact.getPhone1());
                }
                case Telefon2: {
                    return StringUtils.defaultString((String)contact.getPhone2());
                }
                case Natel: {
                    return StringUtils.defaultString((String)contact.getMobile());
                }
                case E_Mail: {
                    return StringUtils.defaultString((String)contact.getEmail());
                }
            }
        }
        return null;
    }

    private static enum ContactAttribute implements ILocalizedEnum
    {
        Name("Name des Kontakt"),
        Anschrift("Mehrzeilige Anschrift"),
        Anschriftzeile("Einzeilige Anschrift"),
        Strasse("Strasse des Kontakt"),
        Plz("Postleitzahl des Kontakt"),
        Ort("Ort des Kontakt"),
        Telefon1("Telefon des Kontakt"),
        Natel("Natel des Kontakt"),
        Telefon2("2tes Telefon des Kontakt"),
        E_Mail("E-Mail des Kontakt");

        final String description;

        private ContactAttribute(String description) {
            this.description = description;
        }

        public String getLocaleText() {
            return this.description;
        }
    }
}

