/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.services.internal.console;

import ch.elexis.core.console.AbstractConsoleCommandProvider;
import ch.elexis.core.console.CmdAdvisor;
import ch.elexis.core.console.CmdParam;
import ch.elexis.core.model.message.TransientMessage;
import ch.elexis.core.services.IContextService;
import ch.elexis.core.services.IMessageService;
import ch.elexis.core.services.IModelService;
import ch.elexis.core.status.ObjectStatus;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.osgi.framework.console.CommandInterpreter;
import org.eclipse.osgi.framework.console.CommandProvider;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={CommandProvider.class}, immediate=true)
public class ServicesConsoleCommandProvider
extends AbstractConsoleCommandProvider {
    @Reference(target="(service.model.name=ch.elexis.core.model)")
    private IModelService coreModelService;
    @Reference
    private IContextService contextService;
    @Reference
    private IMessageService messageService;

    @Activate
    public void activate() {
        this.register(((Object)((Object)this)).getClass());
    }

    @CmdAdvisor(description="Core Services")
    public void _srv(CommandInterpreter ci) {
        this.executeCommand("srv", ci);
    }

    @CmdAdvisor(description="send an internal message")
    public void __srv_message(@CmdParam(required=true, description="contactid of receiver") String contactid, @CmdParam(required=true, description="message to send") String message) {
        if (StringUtils.isEmpty((CharSequence)contactid)) {
            this.missingArgument("contactid");
            return;
        }
        if (StringUtils.isEmpty((CharSequence)message)) {
            this.missingArgument("message");
            return;
        }
        TransientMessage _message = this.messageService.prepare(this.contextService.getStationIdentifier(), "internal:" + contactid);
        _message.setMessageText(message);
        ObjectStatus status = this.messageService.send(_message);
        this.ok(status);
    }
}

