/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.services.internal;

import ch.elexis.core.ac.ACEAccessBitMap;
import ch.elexis.core.ac.ACEAccessBitMapConstraint;
import ch.elexis.core.ac.AccessControlList;
import ch.elexis.core.ac.AccessControlListUtil;
import ch.elexis.core.ac.EvaluatableACE;
import ch.elexis.core.ac.ObjectEvaluatableACE;
import ch.elexis.core.ac.Right;
import ch.elexis.core.ac.SystemCommandEvaluatableACE;
import ch.elexis.core.constants.ElexisSystemPropertyConstants;
import ch.elexis.core.model.IEncounter;
import ch.elexis.core.model.IInvoice;
import ch.elexis.core.model.IRole;
import ch.elexis.core.model.IUser;
import ch.elexis.core.services.IAccessControlService;
import ch.elexis.core.services.IContextService;
import ch.elexis.core.services.IStoreToStringService;
import ch.elexis.core.services.IUserService;
import ch.elexis.core.utils.CoreUtil;
import com.google.gson.Gson;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
public class RoleBasedAccessControlService
implements IAccessControlService {
    private Logger logger;
    @Reference
    private IContextService contextService;
    @Reference
    private IUserService userService;
    @Reference
    private IStoreToStringService storeToStringService;
    @Reference
    private Gson gson;
    private Map<String, AccessControlList> roleAclMap;
    private Map<IUser, AccessControlList> userAclMap;
    private ThreadLocal<Boolean> privileged;
    private String[] aoboObjects = new String[]{"IEncounter", "IInvoice"};

    public RoleBasedAccessControlService() {
        this.logger = LoggerFactory.getLogger(this.getClass());
        this.roleAclMap = Collections.synchronizedMap(new HashMap());
        this.userAclMap = Collections.synchronizedMap(new HashMap());
        this.privileged = ThreadLocal.withInitial(() -> Boolean.FALSE);
    }

    public boolean evaluate(EvaluatableACE evaluatableAce) {
        if (this.isPrivileged()) {
            return true;
        }
        Optional user = this.contextService.getActiveUser();
        if (user.isPresent()) {
            if (!this.userAclMap.containsKey(user.get())) {
                this.refresh((IUser)user.get());
            }
            boolean result = this.evaluateACE((IUser)user.get(), this.userAclMap.get(user.get()), evaluatableAce);
            if (ElexisSystemPropertyConstants.VERBOSE_ACL_NOTIFICATION && !result) {
                String message = "(ACL " + System.currentTimeMillis() + ") User [" + ((IUser)user.get()).getId() + "]  has no right [" + evaluatableAce.toString() + "]";
                this.logger.info("", new Throwable(message));
            }
            return result;
        }
        this.logger.warn("No active user to evalute");
        return false;
    }

    public void refresh(IUser user) {
        AccessControlList userAccessControlList = this.determineUserAccessControlList(this.userService.getUserRoles(user));
        this.userAclMap.put(user, userAccessControlList);
        if (userAccessControlList.getRolesRepresented().isEmpty()) {
            this.logger.warn("ACE User=[{}] Empty Role Set", (Object)user.getId());
        } else {
            this.logger.info("ACE User=[{}] Roles=[{}]", (Object)user.getId(), (Object)userAccessControlList.getRolesRepresented());
        }
    }

    public boolean isPrivileged() {
        return this.privileged.get() != false || CoreUtil.isTestMode() && this.contextService.getNamed("testAccessControl").isEmpty();
    }

    private AccessControlList determineUserAccessControlList(List<IRole> roles) {
        if (roles.isEmpty()) {
            return new AccessControlList();
        }
        AccessControlList accessControlList = null;
        for (IRole role : roles) {
            if (accessControlList == null) {
                accessControlList = this.getOrLoadRoleAccessControlList(role);
                continue;
            }
            AccessControlList _accessControlList = this.roleAclMap.get(role.getId().toLowerCase());
            if (_accessControlList == null) {
                _accessControlList = this.getOrLoadRoleAccessControlList(role);
            }
            if (_accessControlList != null) {
                accessControlList = AccessControlListUtil.merge((AccessControlList)accessControlList, (AccessControlList)_accessControlList);
                continue;
            }
            this.logger.warn("Unknown role [" + role.getId() + "]");
        }
        return accessControlList;
    }

    private AccessControlList getOrLoadRoleAccessControlList(IRole iRole) {
        String _role = iRole.getId().toLowerCase();
        if (!this.roleAclMap.containsKey(_role)) {
            InputStream jsonStream = null;
            if (iRole.isSystemRole()) {
                jsonStream = AccessControlList.class.getClassLoader().getResourceAsStream("/rsc/acl/" + _role + ".json");
            } else {
                String jsonValue = (String)iRole.getExtInfo((Object)"json");
                if (StringUtils.isNotBlank((CharSequence)jsonValue)) {
                    try {
                        jsonStream = new ByteArrayInputStream(jsonValue.getBytes("UTF-8"));
                    }
                    catch (UnsupportedEncodingException e) {
                        this.logger.error("Invalid role custom json acl [{}]", (Object)_role, (Object)e);
                    }
                }
            }
            if (jsonStream != null) {
                Optional<AccessControlList> acl = this.readAccessControlList(jsonStream);
                if (acl.isPresent()) {
                    this.roleAclMap.put(_role, acl.get());
                } else {
                    this.logger.error("Error loading role acl [{}]", (Object)_role);
                }
            } else {
                this.logger.warn("No role acl [{}] file", (Object)_role);
            }
        }
        return this.roleAclMap.get(_role);
    }

    public Optional<AccessControlList> readAccessControlList(InputStream jsonStream) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (InputStreamReader inputStreamReader = new InputStreamReader(jsonStream);){
                AccessControlList acl = (AccessControlList)this.gson.fromJson((Reader)inputStreamReader, AccessControlList.class);
                return Optional.of(acl);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            this.logger.error("Error reading acl json", (Throwable)e);
            return Optional.empty();
        }
    }

    private boolean evaluateACE(IUser user, AccessControlList acl, EvaluatableACE ace) {
        if (ace instanceof ObjectEvaluatableACE) {
            ObjectEvaluatableACE _ace = (ObjectEvaluatableACE)ace;
            ACEAccessBitMap useracebm = (ACEAccessBitMap)acl.getObject().get(_ace.getObject());
            if (useracebm != null) {
                byte[] aceBitMap = useracebm.getAccessRightMap();
                byte[] requested = _ace.getRequestedRightMap();
                byte[] evaluated = new byte[Right.values().length];
                short flattenedbitmap = 0;
                int i = 0;
                while (i < evaluated.length) {
                    if (aceBitMap[i] == 4) {
                        aceBitMap[i] = 1;
                        flattenedbitmap = (short)(flattenedbitmap | 1 << i);
                    } else if (aceBitMap[i] == 2 || aceBitMap[i] == 1) {
                        if (StringUtils.isNotEmpty((CharSequence)_ace.getStoreToString()) && this.isAoboObject(_ace.getObject())) {
                            if (this.evaluateAobo(user, _ace)) {
                                aceBitMap[i] = 1;
                                flattenedbitmap = (short)(flattenedbitmap | 1 << i);
                            } else {
                                aceBitMap[i] = 0;
                            }
                        } else {
                            aceBitMap[i] = 1;
                            flattenedbitmap = (short)(flattenedbitmap | 1 << i);
                        }
                    }
                    evaluated[i] = (byte)(aceBitMap[i] & requested[i]);
                    ++i;
                }
                boolean result = (flattenedbitmap & _ace.getRequested()) == _ace.getRequested();
                return result;
            }
        } else if (ace instanceof SystemCommandEvaluatableACE) {
            SystemCommandEvaluatableACE _ace = (SystemCommandEvaluatableACE)ace;
            return this.evaluateSystemCommandACE(acl, _ace);
        }
        return false;
    }

    private boolean evaluateAobo(IUser user, ObjectEvaluatableACE _ace) {
        List<String> aoboIds = this.getAoboMandatorIds(user);
        Optional object = this.storeToStringService.loadFromString(_ace.getStoreToString());
        if (object.isPresent()) {
            String id = null;
            if (object.get() instanceof IEncounter) {
                if (((IEncounter)object.get()).getMandator() != null) {
                    id = ((IEncounter)object.get()).getMandator().getId();
                }
            } else if (object.get() instanceof IInvoice) {
                if (((IInvoice)object.get()).getMandator() != null) {
                    id = ((IInvoice)object.get()).getMandator().getId();
                }
            } else {
                this.logger.warn("Unknown aobo object [{}]", (Object)_ace.getStoreToString());
            }
            return id != null ? aoboIds.contains(id) : true;
        }
        this.logger.warn("Could not load aobo object [{}]", (Object)_ace.getStoreToString());
        return false;
    }

    public String getSelfMandatorId() {
        Optional user = this.contextService.getActiveUser();
        if (user.isPresent() && ((IUser)user.get()).getAssignedContact() != null) {
            return ((IUser)user.get()).getAssignedContact().getId();
        }
        return "-1";
    }

    private List<String> getAoboMandatorIds(IUser user) {
        ArrayList<String> ret = new ArrayList<String>();
        if (user.getAssignedContact() != null) {
            ret.add(user.getAssignedContact().getId());
            this.userService.getExecutiveDoctorsWorkingFor(user, true).stream().forEach(m -> {
                boolean bl = ret.add(m.getId());
            });
        }
        return ret;
    }

    public List<String> getAoboMandatorIds() {
        Optional user = this.contextService.getActiveUser();
        if (user.isPresent()) {
            return this.getAoboMandatorIds((IUser)user.get());
        }
        return Collections.emptyList();
    }

    public List<String> getAoboMandatorIdsForSqlIn() {
        ArrayList<String> ret = new ArrayList<String>();
        ret.add("-1");
        ret.addAll(this.getAoboMandatorIds());
        return ret;
    }

    private boolean isAoboObject(String object) {
        return Arrays.asList(this.aoboObjects).stream().filter(aobo -> object.endsWith((String)aobo)).findFirst().isPresent();
    }

    private boolean evaluateSystemCommandACE(AccessControlList acl, SystemCommandEvaluatableACE _ace) {
        if (acl.getSystemCommand().containsKey(_ace.getSystemCommandId())) {
            ACEAccessBitMap aceAccessBitMap = (ACEAccessBitMap)acl.getSystemCommand().get(_ace.getSystemCommandId());
            return aceAccessBitMap.grants(Right.EXECUTE);
        }
        return false;
    }

    public void doPrivileged(Runnable runnable) {
        try {
            this.privileged.set(Boolean.TRUE);
            this.logger.trace("Executing priviledged [" + String.valueOf(runnable) + "]");
            runnable.run();
        }
        finally {
            this.privileged.set(Boolean.FALSE);
        }
    }

    public Optional<ACEAccessBitMapConstraint> isAoboOrSelf(ObjectEvaluatableACE evaluatableAce) {
        if (this.isPrivileged()) {
            return Optional.empty();
        }
        if (!this.isAoboObject(evaluatableAce.getObject())) {
            return Optional.empty();
        }
        Optional user = this.contextService.getActiveUser();
        if (user.isPresent()) {
            AccessControlList acl;
            ACEAccessBitMap useracebm;
            if (!this.userAclMap.containsKey(user.get())) {
                this.refresh((IUser)user.get());
            }
            if ((useracebm = (ACEAccessBitMap)(acl = this.userAclMap.get(user.get())).getObject().get(evaluatableAce.getObject())) != null) {
                byte[] aceBitMap = useracebm.getAccessRightMap();
                byte[] requested = evaluatableAce.getRequestedRightMap();
                int i = 0;
                while (i < requested.length) {
                    if (requested[i] == 1 && aceBitMap[i] == 1) {
                        return Optional.of(ACEAccessBitMapConstraint.SELF);
                    }
                    if (requested[i] == 1 && aceBitMap[i] == 2) {
                        return Optional.of(ACEAccessBitMapConstraint.AOBO);
                    }
                    ++i;
                }
            }
        } else {
            this.logger.warn("No active user to test aobo");
        }
        return Optional.empty();
    }
}

