/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.services.holder;

import ch.elexis.core.model.IMandator;
import ch.elexis.core.services.IContextService;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component
public class ContextServiceHolder {
    private static IContextService contextService;

    @Reference
    public void setContextService(IContextService contextService) {
        ContextServiceHolder.contextService = contextService;
    }

    public static IContextService get() {
        if (contextService == null) {
            throw new IllegalStateException("No IContextService available");
        }
        return contextService;
    }

    public static boolean isAvailable() {
        return contextService != null;
    }

    public static IMandator getActiveMandatorOrNull() {
        if (contextService != null) {
            return contextService.getActiveMandator().orElse(null);
        }
        return null;
    }

    public static IMandator getActiveMandatorOrThrow() {
        if (contextService != null) {
            return (IMandator)contextService.getActiveMandator().orElseThrow(() -> new IllegalStateException("No active IMandator found"));
        }
        throw new IllegalStateException("No IContextService available");
    }
}

