/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.services;

import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.IStoreToStringContribution;
import ch.elexis.core.services.IStoreToStringService;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component
public class StoreToStringService
implements IStoreToStringService {
    private List<IStoreToStringContribution> contributions = new CopyOnWriteArrayList<IStoreToStringContribution>();
    private Map<Class<?>, IStoreToStringContribution> classToContributionMap = new HashMap();
    private Cache<String, Identifiable> loadFromStringCache = CacheBuilder.newBuilder().expireAfterAccess(15L, TimeUnit.SECONDS).maximumSize(100L).build();

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    public synchronized void setCodeElementServiceContribution(IStoreToStringContribution contribution) {
        this.contributions.add(contribution);
    }

    public synchronized void unsetCodeElementServiceContribution(IStoreToStringContribution contribution) {
        this.contributions.remove(contribution);
    }

    public Optional<String> storeToString(Identifiable identifiable) {
        IStoreToStringContribution contribution = this.classToContributionMap.get(identifiable.getClass());
        if (contribution != null) {
            return contribution.storeToString(identifiable);
        }
        for (IStoreToStringContribution iStoreToStringContribution : this.contributions) {
            Optional string = iStoreToStringContribution.storeToString(identifiable);
            if (!string.isPresent()) continue;
            this.classToContributionMap.put(identifiable.getClass(), iStoreToStringContribution);
            return string;
        }
        return Optional.empty();
    }

    public Optional<Identifiable> loadFromString(String storeToString) {
        if (storeToString != null) {
            Identifiable cached = (Identifiable)this.loadFromStringCache.getIfPresent((Object)storeToString);
            if (cached != null) {
                return Optional.of(cached);
            }
            for (IStoreToStringContribution iStoreToStringContribution : this.contributions) {
                Optional identifiable = iStoreToStringContribution.loadFromString(storeToString);
                if (!identifiable.isPresent()) continue;
                this.loadFromStringCache.put((Object)storeToString, (Object)((Identifiable)identifiable.get()));
                return identifiable;
            }
        }
        return Optional.empty();
    }

    public List<Identifiable> loadFromStringWithIdPart(String partialStoreToString) {
        ArrayList ret = new ArrayList();
        if (partialStoreToString != null) {
            for (IStoreToStringContribution iStoreToStringContribution : this.contributions) {
                List loaded = iStoreToStringContribution.loadFromStringWithIdPart(partialStoreToString);
                if (loaded.isEmpty()) continue;
                ret.addAll(loaded);
            }
        }
        return ret.parallelStream().filter(Objects::nonNull).collect(Collectors.toList());
    }

    public Class<?> getEntityForType(String type) {
        if (type != null) {
            for (IStoreToStringContribution iStoreToStringContribution : this.contributions) {
                Class loaded = iStoreToStringContribution.getEntityForType(type);
                if (loaded == null) continue;
                return loaded;
            }
        }
        return null;
    }

    public String getTypeForEntity(Object entityInstance) {
        if (entityInstance != null) {
            for (IStoreToStringContribution iStoreToStringContribution : this.contributions) {
                String loaded = iStoreToStringContribution.getTypeForEntity(entityInstance);
                if (loaded == null) continue;
                return loaded;
            }
        }
        return null;
    }

    public String getTypeForModel(Class<?> interfaze) {
        if (interfaze != null) {
            for (IStoreToStringContribution iStoreToStringContribution : this.contributions) {
                String loaded = iStoreToStringContribution.getTypeForModel(interfaze);
                if (loaded == null) continue;
                return loaded;
            }
        }
        return null;
    }
}

