/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.services;

import ch.elexis.core.ac.ACEAccessBitMapConstraint;
import ch.elexis.core.ac.EvACE;
import ch.elexis.core.ac.Right;
import ch.elexis.core.lock.types.LockResponse;
import ch.elexis.core.model.IBillable;
import ch.elexis.core.model.IBillableVerifier;
import ch.elexis.core.model.IBilled;
import ch.elexis.core.model.ICodeElement;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.ICoverage;
import ch.elexis.core.model.IDiagnosis;
import ch.elexis.core.model.IEncounter;
import ch.elexis.core.model.IMandator;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.IUser;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.ModelPackage;
import ch.elexis.core.model.billable.DefaultVerifier;
import ch.elexis.core.model.builder.IEncounterBuilder;
import ch.elexis.core.services.IAccessControlService;
import ch.elexis.core.services.IBillingService;
import ch.elexis.core.services.ICodeElementService;
import ch.elexis.core.services.IConfigService;
import ch.elexis.core.services.ICoverageService;
import ch.elexis.core.services.IEncounterService;
import ch.elexis.core.services.IModelService;
import ch.elexis.core.services.INamedQuery;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.services.IStoreToStringService;
import ch.elexis.core.services.holder.BillingServiceHolder;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.services.holder.CoverageServiceHolder;
import ch.elexis.core.services.holder.LocalLockServiceHolder;
import ch.elexis.core.services.holder.StoreToStringServiceHolder;
import ch.elexis.core.text.model.Samdas;
import ch.rgw.tools.Money;
import ch.rgw.tools.Result;
import ch.rgw.tools.VersionedResource;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.LoggerFactory;

@Component
public class EncounterService
implements IEncounterService {
    @Reference(target="(service.model.name=ch.elexis.core.model)")
    private IModelService coreModelService;
    @Reference
    private IAccessControlService accessControlService;
    @Reference
    private ICodeElementService codeElementService;
    @Reference
    private IBillingService billingService;
    @Reference
    private IConfigService configService;
    @Reference
    private IStoreToStringService storeToStringService;
    @Reference
    private ICoverageService coverageService;

    public boolean isEditable(IEncounter encounter) {
        boolean editable = false;
        if (encounter != null) {
            boolean hasRight = this.accessControlService.evaluate(EvACE.of(IEncounter.class, (Right)Right.UPDATE, (String)((String)this.storeToStringService.storeToString((Identifiable)encounter).get())));
            editable = hasRight ? this.isEditableInternal(encounter) : this.billingService.isEditable(encounter).isOK();
        }
        return editable;
    }

    public Result<IEncounter> transferToMandator(IEncounter encounter, IMandator mandator, boolean ignoreEditable) {
        if (encounter.getMandator().equals(mandator)) {
            return Result.OK();
        }
        Result editableResult = this.billingService.isEditable(encounter);
        if (!editableResult.isOK() && !ignoreEditable) {
            return editableResult;
        }
        Result<IEncounter> result = new Result<IEncounter>((Object)encounter);
        encounter.setMandator(mandator);
        CoreModelServiceHolder.get().save((Identifiable)encounter);
        result = this.reBillEncounter(encounter);
        this.coreModelService.save((Identifiable)encounter);
        ContextServiceHolder.get().postEvent("info/elexis/model/update", (Object)encounter);
        return result;
    }

    public Result<IEncounter> transferToCoverage(IEncounter encounter, ICoverage coverage, boolean ignoreEditable) {
        if (encounter.getCoverage().equals(coverage)) {
            return Result.OK();
        }
        Result editableResult = this.billingService.isEditable(encounter);
        if (!editableResult.isOK() && !ignoreEditable) {
            return editableResult;
        }
        Result<IEncounter> result = new Result<IEncounter>((Object)encounter);
        ICoverage encounterCovearage = encounter.getCoverage();
        encounter.setCoverage(coverage);
        this.coreModelService.save((Identifiable)encounter);
        if (encounterCovearage != null) {
            result = this.reBillEncounter(encounter);
        }
        encounter.addUpdated((EStructuralFeature)ModelPackage.Literals.IENCOUNTER__COVERAGE);
        this.coreModelService.save((Identifiable)encounter);
        ContextServiceHolder.get().setActiveCoverage(coverage);
        return result;
    }

    public Result<IEncounter> reBillEncounter(IEncounter encounter) {
        Result result = new Result((Object)encounter);
        List encounterBilled = encounter.getBilled();
        for (IBilled billed : encounterBilled) {
            IBillable billable = billed.getBillable();
            if (billable != null) continue;
            String message = "Could not resolve billable for billed [" + String.valueOf(billed) + "]";
            return new Result(Result.SEVERITY.ERROR, 0, message, (Object)encounter, false);
        }
        List<IBilled> tardocVerrechnet = this.getTardocOnly(encounter.getBilled());
        List<IBilled> tardocZuschlagVerrechnet = tardocVerrechnet.stream().filter(v -> this.isZuschlag((IBilled)v)).toList();
        tardocVerrechnet.removeAll(tardocZuschlagVerrechnet);
        List<IBilled> tardocReferenzVerrechnet = tardocVerrechnet.stream().filter(v -> this.isReferenz((IBilled)v)).toList();
        tardocVerrechnet.removeAll(tardocReferenzVerrechnet);
        List<IBilled> tarmedVerrechnet = this.getTarmedOnly(encounter.getBilled());
        List<IBilled> tarmedZuschlagVerrechnet = tardocVerrechnet.stream().filter(v -> this.isZuschlag((IBilled)v)).toList();
        tardocVerrechnet.removeAll(tardocZuschlagVerrechnet);
        List<IBilled> tarmedReferenzVerrechnet = tardocVerrechnet.stream().filter(v -> this.isReferenz((IBilled)v)).toList();
        tardocVerrechnet.removeAll(tardocReferenzVerrechnet);
        List<IBilled> othersVerrechnet = this.getOthersOnly(encounter.getBilled());
        this.reCharge(tardocVerrechnet, encounter, (Result<IEncounter>)result);
        this.reCharge(tardocZuschlagVerrechnet, encounter, (Result<IEncounter>)result);
        this.reCharge(tardocReferenzVerrechnet, encounter, (Result<IEncounter>)result);
        this.reCharge(tarmedVerrechnet, encounter, (Result<IEncounter>)result);
        this.reCharge(tarmedZuschlagVerrechnet, encounter, (Result<IEncounter>)result);
        this.reCharge(tarmedReferenzVerrechnet, encounter, (Result<IEncounter>)result);
        this.reCharge(othersVerrechnet, encounter, (Result<IEncounter>)result);
        return result;
    }

    private void reCharge(List<IBilled> billed, IEncounter encounter, Result<IEncounter> result) {
        HashMap amountMap = new HashMap();
        HashMap verrechenbarMap = new HashMap();
        billed.forEach(v -> {
            Double d = amountMap.put(v, v.getAmount());
        });
        billed.forEach(v -> this.getMatchingVerrechenbar((IBilled)v, encounter, result).ifPresent(c -> {
            ICodeElement iCodeElement = verrechenbarMap.put(v, c);
        }));
        billed = billed.stream().filter(v -> verrechenbarMap.containsKey(v)).toList();
        billed.forEach(v -> this.removeVerrechnet(encounter, (IBilled)v, result));
        billed.forEach(v -> this.addVerrechnet(encounter, (ICodeElement)verrechenbarMap.get(v), (Double)amountMap.get(v), result));
    }

    private void addVerrechnet(IEncounter encounter, ICodeElement billable, double amount, Result<IEncounter> result) {
        int i = 0;
        while ((double)i < amount) {
            Result addRes = BillingServiceHolder.get().bill((IBillable)billable, encounter, 1.0);
            if (!addRes.isOK()) {
                String message = "Achtung: durch den Fall wechsel wurde die Position " + billable.getCode() + " automatisch entfernt.\n" + addRes.toString();
                result.addMessage(Result.SEVERITY.WARNING, message, (Object)encounter);
            }
            ++i;
        }
    }

    private void removeVerrechnet(IEncounter encounter, IBilled billed, Result<IEncounter> result) {
        LockResponse lockResult = LocalLockServiceHolder.get().acquireLockBlocking((Object)billed, 10, (IProgressMonitor)new NullProgressMonitor());
        if (lockResult.isOk()) {
            Result removeRes = BillingServiceHolder.get().removeBilled(billed, encounter);
            if (!removeRes.isOK()) {
                String message = "Achtung: Position " + billed.getCode() + " konnte nicht entfernt werden.";
                result.addMessage(Result.SEVERITY.WARNING, message, (Object)encounter);
            }
            LocalLockServiceHolder.get().releaseLock(lockResult.getLockInfo());
        } else {
            String message = "Achtung: Locking von Position " + billed.getCode() + " fehlgeschlagen.";
            result.addMessage(Result.SEVERITY.WARNING, message, (Object)encounter);
        }
    }

    private Optional<ICodeElement> getMatchingVerrechenbar(IBilled billed, IEncounter encounter, Result<IEncounter> result) {
        IBillable billable = billed.getBillable();
        if (billable != null) {
            HashMap<Object, Object> context = this.getCodeElementServiceContext(encounter);
            Optional matchingVerrechenbar = this.codeElementService.loadFromString(billable.getCodeSystemName(), billable.getCode(), context);
            if (matchingVerrechenbar.isEmpty()) {
                String message = "Achtung: durch den Fall wechsel wurde die Position " + billable.getCode() + " automatisch entfernt, da diese im neuen Fall nicht vorhanden ist.";
                result.addMessage(Result.SEVERITY.WARNING, message, (Object)encounter);
            } else {
                return matchingVerrechenbar;
            }
        }
        return Optional.empty();
    }

    private List<IBilled> getTardocOnly(List<IBilled> list) {
        ArrayList<IBilled> ret = new ArrayList<IBilled>();
        for (IBilled verrechnet : list) {
            IBillable billable = verrechnet.getBillable();
            if (!billable.getCodeSystemName().contains("TARDOC")) continue;
            ret.add(verrechnet);
        }
        return ret;
    }

    private List<IBilled> getTarmedOnly(List<IBilled> list) {
        ArrayList<IBilled> ret = new ArrayList<IBilled>();
        for (IBilled verrechnet : list) {
            IBillable billable = verrechnet.getBillable();
            if (!billable.getCodeSystemName().contains("Tarmed")) continue;
            ret.add(verrechnet);
        }
        return ret;
    }

    private List<IBilled> getOthersOnly(List<IBilled> list) {
        ArrayList<IBilled> ret = new ArrayList<IBilled>();
        for (IBilled verrechnet : list) {
            IBillable billable = verrechnet.getBillable();
            if (billable.getCodeSystemName().contains("Tarmed") || billable.getCodeSystemName().contains("TARDOC")) continue;
            ret.add(verrechnet);
        }
        return ret;
    }

    private boolean isReferenz(IBilled tardocVerr) {
        IBillable verrechenbar = tardocVerr.getBillable();
        String serviceTyp = this.getServiceTypReflective(verrechenbar);
        return serviceTyp != null && serviceTyp.equals("R");
    }

    private boolean isZuschlag(IBilled tardocVerr) {
        IBillable verrechenbar = tardocVerr.getBillable();
        Boolean serviceTyp = this.getIsZuschlagsleistungReflective(verrechenbar);
        return serviceTyp != null && serviceTyp != false;
    }

    private String getServiceTypReflective(IBillable billable) {
        try {
            Method getterMethod = billable.getClass().getMethod("getServiceTyp", null);
            Object typ = getterMethod.invoke((Object)billable, null);
            if (typ instanceof String) {
                return (String)typ;
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            LoggerFactory.getLogger(this.getClass()).warn("Could not get service typ of [" + String.valueOf(billable) + "]", (Object)e.getMessage());
        }
        return null;
    }

    private Boolean getIsZuschlagsleistungReflective(IBillable billable) {
        try {
            Method getterMethod = billable.getClass().getMethod("isZuschlagsleistung", null);
            Object typ = getterMethod.invoke((Object)billable, null);
            if (typ instanceof Boolean) {
                return (Boolean)typ;
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            LoggerFactory.getLogger(this.getClass()).warn("Could not get service typ of [" + String.valueOf(billable) + "]", (Object)e.getMessage());
        }
        return null;
    }

    private HashMap<Object, Object> getCodeElementServiceContext(IEncounter encounter) {
        HashMap<Object, Object> ret = new HashMap<Object, Object>();
        ret.put(ICodeElementService.ContextKeys.CONSULTATION, encounter);
        ICoverage coverage = encounter.getCoverage();
        if (coverage != null) {
            ret.put(ICodeElementService.ContextKeys.COVERAGE, coverage);
        }
        return ret;
    }

    private boolean isEditableInternal(IEncounter encounter) {
        boolean mandatorLoggedIn;
        ICoverage coverage = encounter.getCoverage();
        if (coverage != null && !coverage.isOpen()) {
            return false;
        }
        IMandator encounterMandator = encounter.getMandator();
        boolean checkMandant = !this.accessControlService.evaluate(EvACE.of((String)"LSTG_CHARGE_FOR_ALL"));
        boolean mandatorOK = true;
        IMandator activeMandator = ContextServiceHolder.get().getActiveMandator().orElse(null);
        boolean bl = mandatorLoggedIn = activeMandator != null;
        if (encounterMandator != null && activeMandator != null && checkMandant && !encounterMandator.getId().equals(activeMandator.getId())) {
            mandatorOK = false;
        }
        boolean ok = mandatorOK && mandatorLoggedIn;
        return ok;
    }

    public Optional<IEncounter> getLatestEncounter(IPatient patient, boolean create) {
        List coverages;
        if (!ContextServiceHolder.get().getActiveMandator().isPresent()) {
            return Optional.empty();
        }
        IMandator activeMandator = (IMandator)ContextServiceHolder.get().getActiveMandator().get();
        IContact userContact = (IContact)ContextServiceHolder.get().getActiveUserContact().get();
        IQuery encounterQuery = CoreModelServiceHolder.get().getQuery(IEncounter.class);
        if (!ConfigServiceHolder.get().get(userContact, "fall/load_consall", false)) {
            encounterQuery.and((EStructuralFeature)ModelPackage.Literals.IENCOUNTER__MANDATOR, IQuery.COMPARATOR.EQUALS, (Object)activeMandator);
        }
        if ((coverages = patient.getCoverages()) == null || coverages.isEmpty()) {
            return create ? this.createCoverageAndEncounter(patient) : Optional.empty();
        }
        encounterQuery.startGroup();
        boolean termInserted = false;
        for (ICoverage coverage : coverages) {
            if (!coverage.isOpen()) continue;
            encounterQuery.or((EStructuralFeature)ModelPackage.Literals.IENCOUNTER__COVERAGE, IQuery.COMPARATOR.EQUALS, (Object)coverage);
            termInserted = true;
        }
        if (!termInserted) {
            return create ? this.createCoverageAndEncounter(patient) : Optional.empty();
        }
        encounterQuery.andJoinGroups();
        encounterQuery.orderBy((EStructuralFeature)ModelPackage.Literals.IENCOUNTER__DATE, IQuery.ORDER.DESC);
        List list = encounterQuery.execute();
        if (list == null || list.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of((IEncounter)list.get(0));
    }

    private Optional<IEncounter> createCoverageAndEncounter(IPatient patient) {
        ICoverage coverage = CoverageServiceHolder.get().createDefaultCoverage(patient);
        Optional activeMandator = ContextServiceHolder.get().getActiveMandator();
        if (activeMandator.isPresent()) {
            return Optional.of((IEncounter)new IEncounterBuilder(CoreModelServiceHolder.get(), coverage, (IMandator)activeMandator.get()).buildAndSave());
        }
        return Optional.empty();
    }

    public Optional<IEncounter> getLatestEncounter(IPatient patient) {
        List result = null;
        Optional aoboOrSelf = this.accessControlService.isAoboOrSelf(EvACE.of(IEncounter.class, (Right)Right.READ));
        if (aoboOrSelf.isPresent()) {
            INamedQuery query = CoreModelServiceHolder.get().getNamedQueryByName(IEncounter.class, IEncounter.class, "Behandlung.patient.last.aobo");
            if (aoboOrSelf.get() == ACEAccessBitMapConstraint.AOBO) {
                result = query.executeWithParameters(query.getParameterMap(new Object[]{"patient", patient, "aoboids", this.accessControlService.getAoboMandatorIdsForSqlIn()}));
            } else if (aoboOrSelf.get() == ACEAccessBitMapConstraint.SELF) {
                result = query.executeWithParameters(query.getParameterMap(new Object[]{"patient", patient, "aoboids", Collections.singletonList(this.accessControlService.getSelfMandatorId())}));
            }
        } else {
            INamedQuery query = CoreModelServiceHolder.get().getNamedQueryByName(IEncounter.class, IEncounter.class, "Behandlung.patient.last");
            result = query.executeWithParameters(query.getParameterMap(new Object[]{"patient", patient}));
        }
        if (result != null && !result.isEmpty()) {
            return Optional.of((IEncounter)result.get(0));
        }
        return Optional.empty();
    }

    private String getVersionRemark() {
        String remark = "edit";
        Optional activeUser = ContextServiceHolder.get().getActiveUser();
        if (activeUser.isPresent()) {
            remark = ((IUser)activeUser.get()).getLabel();
        }
        return remark;
    }

    public synchronized void updateVersionedEntry(IEncounter encounter, Samdas samdas) {
        this.updateVersionedEntry(encounter, samdas.toString(), this.getVersionRemark());
    }

    public synchronized void updateVersionedEntry(IEncounter encounter, String entryXml, String remark) {
        this.coreModelService.refresh((Identifiable)encounter, true);
        encounter.getVersionedEntry().update(entryXml, remark);
        this.coreModelService.save((Identifiable)encounter);
    }

    public Money getSales(IEncounter encounter) {
        Money ret = new Money();
        for (IBilled billed : encounter.getBilled()) {
            ret.addMoney(billed.getTotal());
        }
        return ret;
    }

    public List<IEncounter> getAllEncountersForPatient(IPatient patient) {
        IQuery query = CoreModelServiceHolder.get().getQuery(ICoverage.class);
        query.and((EStructuralFeature)ModelPackage.Literals.ICOVERAGE__PATIENT, IQuery.COMPARATOR.EQUALS, (Object)patient);
        List coverages = query.execute();
        List<IEncounter> collect = coverages.stream().flatMap(cv -> cv.getEncounters().stream()).sorted((c1, c2) -> c2.getDate().compareTo(c1.getDate())).collect(Collectors.toList());
        return collect;
    }

    public List<IBilled> getBilledByBillable(IEncounter encounter, IBillable billable) {
        INamedQuery query = CoreModelServiceHolder.get().getNamedQuery(IBilled.class, new String[]{"behandlung", "leistungenCode"});
        return query.executeWithParameters(query.getParameterMap(new Object[]{"behandlung", encounter, "leistungenCode", billable.getId()}));
    }

    public void addDefaultDiagnosis(IEncounter encounter) {
        Optional diagnose;
        String diagnosisSts = this.configService.getActiveUserContact("fall/std_diagnose", "");
        if (diagnosisSts.length() > 1 && (diagnose = StoreToStringServiceHolder.get().loadFromString(diagnosisSts)).isPresent()) {
            encounter.addDiagnosis((IDiagnosis)diagnose.get());
            this.coreModelService.save((Identifiable)encounter);
        }
    }

    public void addXRef(IEncounter encounter, String provider, String id, int pos, String text) {
        ContextServiceHolder.get().sendEvent("info/elexis/locking/prerelease", (Object)encounter);
        VersionedResource vr = encounter.getVersionedEntry();
        String ntext = vr.getHead();
        Samdas samdas = new Samdas(ntext);
        Samdas.Record record = samdas.getRecord();
        Object recText = record.getText();
        if (pos == -1 || pos > ((String)recText).length()) {
            pos = ((String)recText).length();
            recText = (String)recText + "\n" + text;
        } else {
            recText = ((String)recText).substring(0, pos) + "\n" + text + ((String)recText).substring(pos);
        }
        record.setText((String)recText);
        Samdas.XRef xref = new Samdas.XRef(provider, id, ++pos, text.length());
        record.add((Samdas.Range)xref);
        this.updateVersionedEntry(encounter, samdas);
        ContextServiceHolder.get().postEvent("info/elexis/model/update", (Object)encounter);
    }

    public Result<IEncounter> setEncounterDate(IEncounter encounter, LocalDate newDate) {
        encounter.setDate(newDate);
        CoreModelServiceHolder.get().save((Identifiable)encounter);
        Result ret = new Result((Object)encounter);
        ArrayList<IBillableVerifier> verifiers = new ArrayList<IBillableVerifier>();
        for (IBilled billed : encounter.getBilled()) {
            IBillable billable = billed.getBillable();
            if (billable == null || billable.getVerifier() == null || billable.getVerifier() instanceof DefaultVerifier || verifiers.stream().anyMatch(v -> v.getClass().equals(billable.getVerifier().getClass()))) continue;
            verifiers.add(billable.getVerifier());
        }
        if (!verifiers.isEmpty()) {
            for (IBillableVerifier verifier : verifiers) {
                Result result = verifier.verify(encounter);
                if (result.isOK()) continue;
                List messages = result.getMessages();
                for (Result.msg msg2 : messages) {
                    IBilled billed;
                    IBillable billable;
                    if (!(msg2.getObject() instanceof IBilled) || (billable = (billed = (IBilled)msg2.getObject()).getBillable()) == null) continue;
                    encounter.removeBilled(billed);
                    String message = "Achtung: durch die \u00c4nderung wurde die Position " + billable.getCode() + " automatisch entfernt.\nLimitation: " + msg2.getText();
                    ret.addMessage(Result.SEVERITY.WARNING, message, (Object)encounter);
                }
            }
        }
        return ret;
    }

    public boolean canDelete(IEncounter element) {
        if (element != null) {
            return element.getBilled().isEmpty() && element.getDiagnoses().isEmpty();
        }
        return false;
    }
}

