/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.services;

import ch.elexis.core.model.Deleteable;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.ILabItem;
import ch.elexis.core.model.ILabMapping;
import ch.elexis.core.model.ILabOrder;
import ch.elexis.core.model.ILabResult;
import ch.elexis.core.model.ILaboratory;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.ModelPackage;
import ch.elexis.core.model.builder.IContactBuilder;
import ch.elexis.core.model.builder.ILabItemBuilder;
import ch.elexis.core.model.builder.ILabResultBuilder;
import ch.elexis.core.services.AbstractServiceTest;
import ch.elexis.core.services.AllServiceTests;
import ch.elexis.core.services.ILabService;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.types.LabItemTyp;
import ch.elexis.core.utils.OsgiServiceUtil;
import ch.rgw.tools.Result;
import java.util.List;
import java.util.Optional;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class ILabServiceTest
extends AbstractServiceTest {
    private static String FORMULA = "Math.round((04_500-04_501-(04_520/2.2))*100)/100.0";
    private ILabService labService = (ILabService)OsgiServiceUtil.getService(ILabService.class).get();
    static ILaboratory laboratory;
    static ILabItem _04_500;
    static ILabItem _04_501;
    static ILabItem _04_520;
    static ILabItem _04_510_LDL_CALCULATED;
    static ILabResult _04_500_labResult;

    @BeforeClass
    public static void before() {
        laboratory = (ILaboratory)new IContactBuilder.LaboratoryBuilder(CoreModelServiceHolder.get(), "myLab").buildAndSave();
        laboratory.addXid("www.elexis.ch/xid/kontakt/lab/sendingfacility", "ABXMicrosEmi", true);
        _04_500 = new ILabItemBuilder(coreModelService, "TCHO-P", "TCHO-P", "3.88-5.66", "3.88-5.66", "mmol/l", LabItemTyp.NUMERIC, "04 Cholesterin", 500).origin((IContact)laboratory, "TCHO-P", true).buildAndSave();
        _04_501 = new ILabItemBuilder(coreModelService, "HDLC-P", "HDLC-P", "0.93-1.55", "1.16-1.78", "mmol/l", LabItemTyp.NUMERIC, "04 Cholesterin", 501).buildAndSave();
        _04_520 = new ILabItemBuilder(coreModelService, "TG-P", "TG-P", "0.56-1.68", "0.56-1.68", "mmol/l", LabItemTyp.NUMERIC, "04 Cholesterin", 520).buildAndSave();
        _04_510_LDL_CALCULATED = new ILabItemBuilder(coreModelService, "LDL", "LDL (calculated", "<4.0", "<4.0", "mmol/l", LabItemTyp.FORMULA, "04 Cholesterin", 510).build();
        _04_510_LDL_CALCULATED.setFormula(FORMULA);
        coreModelService.save((Identifiable)_04_510_LDL_CALCULATED);
        _04_500_labResult = new ILabResultBuilder(coreModelService, _04_500, AllServiceTests.getPatient()).result("5.33").buildLabOrder("1").buildAndSave();
        new ILabResultBuilder(coreModelService, _04_501, AllServiceTests.getPatient()).result("1.82").buildLabOrder("1").buildAndSave();
        new ILabResultBuilder(coreModelService, _04_520, AllServiceTests.getPatient()).result("1.85").buildLabOrder("1").buildAndSave();
        Assert.assertEquals((Object)"04_500", (Object)_04_500.getVariableName());
        Assert.assertEquals((Object)"04_501", (Object)_04_501.getVariableName());
        Assert.assertEquals((Object)"04_520", (Object)_04_520.getVariableName());
        Assert.assertEquals((Object)"04_510", (Object)_04_510_LDL_CALCULATED.getVariableName());
    }

    @Test
    public void evaluate() {
        ILabResult ldlHldResult = new ILabResultBuilder(coreModelService, _04_510_LDL_CALCULATED, AllServiceTests.getPatient()).buildLabOrder("1").buildAndSave();
        IQuery query = coreModelService.getQuery(ILabOrder.class);
        query.and((EStructuralFeature)ModelPackage.Literals.ILAB_ORDER__RESULT, IQuery.COMPARATOR.EQUALS, (Object)ldlHldResult);
        Assert.assertTrue((boolean)query.executeSingleResult().isPresent());
        Result result = this.labService.evaluate(ldlHldResult);
        Assert.assertTrue((boolean)result.isOK());
        Assert.assertNotNull((Object)result.get());
        Assert.assertEquals((Object)"2.67", (Object)result.get());
        CoreModelServiceHolder.get().remove((Identifiable)ldlHldResult);
    }

    @Test
    public void resolveLabMapping() {
        Assert.assertFalse((boolean)this.labService.getLabMappingByContactAndItem((IContact)laboratory, _04_501).isPresent());
        Optional mapping = this.labService.getLabMappingByContactAndItem((IContact)laboratory, _04_500);
        Assert.assertTrue((boolean)mapping.isPresent());
        Assert.assertEquals((Object)"TCHO-P", (Object)((ILabMapping)mapping.get()).getItemName());
        Assert.assertFalse((boolean)this.labService.getLabMappingByContactAndItem(null, _04_501).isPresent());
    }

    @Test
    public void getLabResultsForPatientWithItemType() {
        ILabResult labResult = new ILabResultBuilder(coreModelService, _04_500, AllServiceTests.getPatient()).result("9.37").buildLabOrder("1").buildAndSave();
        List results = this.labService.getLabResultsForPatientWithItemType(AllServiceTests.getPatient(), LabItemTyp.NUMERIC, false);
        Assert.assertEquals((long)7L, (long)results.size());
        CoreModelServiceHolder.get().delete((Deleteable)labResult);
        results = this.labService.getLabResultsForPatientWithItemType(AllServiceTests.getPatient(), LabItemTyp.NUMERIC, false);
        Assert.assertEquals((long)6L, (long)results.size());
        CoreModelServiceHolder.get().remove((Identifiable)labResult);
    }

    @Test
    public void getLabOrdersInSameOrderIdGroup() {
        List labOrdersInSameOrderIdGroup = this.labService.getLabOrdersInSameOrderIdGroup(_04_500_labResult.getLabOrder(), false);
        Assert.assertEquals((long)3L, (long)labOrdersInSameOrderIdGroup.size());
    }
}

