/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.java;

import com.wstutorial.ws.HelloWorld;
import com.wstutorial.ws.HelloWorldImpl;
import jakarta.xml.ws.Endpoint;
import jakarta.xml.ws.Service;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.namespace.QName;
import org.junit.Assert;
import org.junit.Test;

public class JaxWsTest {
    @Test
    public void jaxwsFunctionality() throws MalformedURLException {
        Endpoint endpoint;
        System.setProperty("javax.xml.ws.spi.Provider", "com.sun.xml.ws.spi.ProviderImpl");
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(Service.class.getClassLoader());
        try {
            endpoint = Endpoint.publish((String)"http://localhost:14429/ws/helloworld", (Object)new HelloWorldImpl());
            Assert.assertTrue((boolean)endpoint.isPublished());
            Assert.assertEquals((Object)"http://schemas.xmlsoap.org/wsdl/soap/http", (Object)endpoint.getBinding().getBindingID());
        }
        finally {
            Thread.currentThread().setContextClassLoader(tccl);
        }
        String namespaceURI = "http://ws.wstutorial.com/";
        String servicePart = "HelloWorldImplService";
        String portName = "HelloWorldImplPort";
        QName serviceQN = new QName(namespaceURI, servicePart);
        QName portQN = new QName(namespaceURI, portName);
        URL wsdlDocumentLocation = this.getClass().getResource("helloworld.wsdl.xml");
        Thread.currentThread().setContextClassLoader(Service.class.getClassLoader());
        try {
            Service service = Service.create((URL)wsdlDocumentLocation, (QName)serviceQN);
            HelloWorld testInterface = (HelloWorld)service.getPort(portQN, HelloWorld.class);
            Assert.assertEquals((Object)"Hello Junge !", (Object)testInterface.sayHelloWorld("Junge"));
        }
        finally {
            Thread.currentThread().setContextClassLoader(tccl);
        }
        endpoint.stop();
        Assert.assertFalse((boolean)endpoint.isPublished());
    }
}

