/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.utils;

import ch.elexis.core.common.DBConnection;
import ch.elexis.core.jdt.NonNull;
import ch.elexis.core.utils.OsgiServiceUtil;
import ch.rgw.io.Settings;
import ch.rgw.tools.StringTool;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.Unmarshaller;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Optional;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBConnectionUtil {
    private static Logger logger = LoggerFactory.getLogger(DBConnectionUtil.class);

    /*
     * Exception decompiling
     */
    private static Object foldObject(byte[] flat, IClassResolver resolver) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static Object foldObject(byte[] flat) {
        return DBConnectionUtil.foldObject(flat, null);
    }

    private static Hashtable<Object, Object> fold(byte[] flat) {
        return (Hashtable)DBConnectionUtil.foldObject(flat);
    }

    private static String applyMySqlTimeZoneWorkaround(String dbConnectString) {
        if (((String)dbConnectString).startsWith("jdbc:mysql:") && !((String)dbConnectString).contains("serverTimezone")) {
            dbConnectString = ((String)dbConnectString).contains("?") ? (String)dbConnectString + "&serverTimezone=Europe/Zurich" : (String)dbConnectString + "?serverTimezone=Europe/Zurich";
            logger.info("MySQL dbConnection string correction [{}]", dbConnectString);
        }
        return dbConnectString;
    }

    public static Optional<DBConnection> getDBConnection(Settings settings) {
        Hashtable<Object, Object> hConn = DBConnectionUtil.getConnectionHashtable(settings);
        if (hConn != null) {
            DBConnection ret = new DBConnection();
            if (!StringUtils.isEmpty((CharSequence)((String)hConn.get("connectionstring")))) {
                String url = (String)hConn.get("connectionstring");
                ret.connectionString = url = DBConnectionUtil.applyMySqlTimeZoneWorkaround(url);
                DBConnection.getHostName((String)url).ifPresent(h -> {
                    String string = dBConnection.hostName = h;
                });
                DBConnection.getDatabaseName((String)url).ifPresent(db -> {
                    String string = dBConnection.databaseName = db;
                });
            }
            if (!StringUtils.isEmpty((CharSequence)((String)hConn.get("user")))) {
                ret.username = (String)hConn.get("user");
            }
            if (!StringUtils.isEmpty((CharSequence)((String)hConn.get("pwd")))) {
                ret.password = (String)hConn.get("pwd");
            }
            if (!StringUtils.isEmpty((CharSequence)((String)hConn.get("driver")))) {
                Optional type = DBConnection.DBType.valueOfDriver((String)((String)hConn.get("driver")));
                type.ifPresent(t -> {
                    DBConnection.DBType dBType = dBConnection.rdbmsType = t;
                });
            }
            if (ret.allValuesSet()) {
                return Optional.of(ret);
            }
            StringBuilder sb = new StringBuilder();
            for (Object object : hConn.keySet()) {
                if (!(object instanceof String)) continue;
                sb.append("\n").append(object).append("->").append(hConn.get(object));
            }
            logger.error("Could not get a valid DBConnection from connection setting:" + sb.toString());
        }
        return Optional.empty();
    }

    @NonNull
    public static Hashtable<Object, Object> getConnectionHashtable(Settings settings) {
        Hashtable<Object, Object> ret = new Hashtable<Object, Object>();
        String cnt = settings.get("verbindung/folded_string", null);
        if (cnt != null) {
            ret = DBConnectionUtil.fold(StringTool.dePrintable((String)cnt));
        }
        return ret;
    }

    public static String getDatabaseProductName() {
        Optional<DataSource> defaultDataSource = OsgiServiceUtil.getService(DataSource.class, "(id=default)");
        if (defaultDataSource.isPresent()) {
            try {
                Connection connection = defaultDataSource.get().getConnection();
                return connection.getMetaData().getDatabaseProductName();
            }
            catch (SQLException e) {
                e.printStackTrace();
                OsgiServiceUtil.ungetService(DataSource.class);
            }
        }
        return "unknown";
    }

    public static void marshall(OutputStream os, DBConnection dbc) throws JAXBException {
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{DBConnection.class});
        Marshaller m = jaxbContext.createMarshaller();
        m.setProperty("jaxb.formatted.output", (Object)true);
        m.marshal((Object)dbc, os);
    }

    public static DBConnection unmarshall(InputStream is) throws JAXBException {
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{DBConnection.class});
        Unmarshaller um = jaxbContext.createUnmarshaller();
        Object o = um.unmarshal(is);
        return (DBConnection)o;
    }

    public static String marshallIntoString(DBConnection dbc) {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (StringWriter sw = new StringWriter();){
                JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{DBConnection.class});
                Marshaller m = jaxbContext.createMarshaller();
                m.setProperty("jaxb.formatted.output", (Object)true);
                m.marshal((Object)dbc, (Writer)sw);
                return sw.toString();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (JAXBException | IOException e) {
            e.printStackTrace();
            return "";
        }
    }

    public static DBConnection unmarshall(String value) {
        if (value == null) {
            return null;
        }
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(value.getBytes(StandardCharsets.UTF_8));
            return DBConnectionUtil.unmarshall(byteArrayInputStream);
        }
        catch (JAXBException e) {
            e.printStackTrace();
            return new DBConnection();
        }
    }

    private static interface IClassResolver {
        public Class<?> resolveClass(ObjectStreamClass var1) throws ClassNotFoundException;
    }
}

