/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.status;

import ch.elexis.core.events.MessageEvent;
import ch.elexis.core.utils.OsgiServiceUtil;
import java.util.HashMap;
import java.util.Optional;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.slf4j.LoggerFactory;

public class ElexisStatus
extends Status {
    public static final int LOG_FATALS = 1;
    public static final int LOG_ERRORS = 2;
    public static final int LOG_WARNINGS = 3;
    public static final int LOG_INFOS = 4;
    public static final int LOG_DEBUGMSG = 5;
    public static final int LOG_TRACE = 6;
    public static final int CODE_NONE = 0;
    public static final int CODE_NOFEEDBACK = 1;
    public static final int CODE_RESTART = 2;
    private int logLevel;

    public ElexisStatus(int severity, String pluginId, int code, String message, Exception exception) {
        super(severity, pluginId, code, message, (Throwable)exception);
        this.logLevel = 2;
    }

    public ElexisStatus(int severity, String pluginId, int code, String message, Exception exception, int logLevel) {
        super(severity, pluginId, code, message, (Throwable)exception);
        this.logLevel = logLevel;
    }

    public ElexisStatus(int severity, String pluginId, int code, String message, int logLevel) {
        super(severity, pluginId, code, message, null);
        this.logLevel = logLevel;
    }

    public ElexisStatus(IStatus status) {
        super(status.getSeverity(), status.getPlugin(), status.getCode(), status.getMessage(), status.getException());
    }

    public int getLogLevel() {
        return this.logLevel;
    }

    public void setLogLevel(int logLevel) {
        this.logLevel = logLevel;
    }

    public void setCode(int code) {
        super.setCode(code);
    }

    public void setMessage(String message) {
        super.setMessage(message);
    }

    public static void fire(ElexisStatus status) {
        HashMap<String, ElexisStatus> properties = new HashMap<String, ElexisStatus>();
        properties.put("status", status);
        Event event = new Event("info/elexis/notification/status", properties);
        Optional<EventAdmin> eventAdmin = OsgiServiceUtil.getService(EventAdmin.class);
        if (eventAdmin.isPresent()) {
            eventAdmin.get().sendEvent(event);
        } else {
            LoggerFactory.getLogger(MessageEvent.class).error("EventAdmin not available. Status not delivered: [{}]", (Object)status);
        }
    }
}

