/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.services;

import ch.elexis.Desk;
import ch.elexis.core.services.ILocalConfigService;
import ch.elexis.core.services.LocalConfigService;
import ch.elexis.core.utils.CoreUtil;
import ch.rgw.io.Settings;
import ch.rgw.io.SysSettings;
import java.io.File;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.Hashtable;
import java.util.UUID;
import org.eclipse.core.runtime.Platform;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.slf4j.LoggerFactory;

@Component
public class LocalConfigServiceImpl
implements ILocalConfigService {
    static Settings localConfig;

    static {
        SysSettings cfg = SysSettings.getOrCreate((int)0, Desk.class);
        cfg.read_xml(String.valueOf(CoreUtil.getWritableUserDir()) + File.separator + LocalConfigServiceImpl.getLocalConfigFileName());
        localConfig = cfg;
    }

    static Settings getLocalConfig() {
        return localConfig;
    }

    @Activate
    public void activate() {
        this.initializeDefaultPreferences();
    }

    private static String getLocalConfigFileName() {
        String[] args = Platform.getApplicationArgs();
        String config = "default";
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (s.startsWith("--use-config=")) {
                String[] c = s.split("=");
                config = c[1];
            }
            ++n2;
        }
        if ("RunFromScratch".equals(System.getProperty("elexis-run-mode"))) {
            config = UUID.randomUUID().toString();
        }
        return "localCfg_" + config + ".xml";
    }

    public static void clear() {
        localConfig.clear();
    }

    public static void flush() {
        localConfig.flush();
    }

    public String get(String key, String defaultValue) {
        return localConfig.get(key, defaultValue);
    }

    public boolean get(String key, boolean defaultValue) {
        return localConfig.get(key, defaultValue);
    }

    public int get(String key, int defaultValue) {
        return localConfig.get(key, defaultValue);
    }

    public boolean set(String key, String value) {
        boolean result;
        if (value == null) {
            localConfig.remove(key);
            result = true;
        } else {
            result = localConfig.set(key, value);
        }
        localConfig.flush();
        LocalConfigServiceImpl.persist();
        return result;
    }

    public boolean set(String key, boolean value) {
        boolean result = localConfig.set(key, value);
        localConfig.flush();
        LocalConfigServiceImpl.persist();
        return result;
    }

    public boolean set(String key, int value) {
        localConfig.set(key, value);
        localConfig.flush();
        LocalConfigServiceImpl.persist();
        return true;
    }

    private static synchronized void persist() {
        SysSettings localCfg = (SysSettings)localConfig;
        String xmlFileName = String.valueOf(CoreUtil.getWritableUserDir()) + File.separator + LocalConfigServiceImpl.getLocalConfigFileName();
        localCfg.write_xml(xmlFileName);
        LoggerFactory.getLogger(LocalConfigService.class).info("LocalConfig persisted to [{}]", (Object)xmlFileName);
    }

    private void initializeDefaultPreferences() {
        localConfig.set("verbindung/Datenbankname_default", "h2");
        String base = CoreUtil.getDefaultDBPath();
        localConfig.set("verbindung/Connectstring_default", "jdbc:h2:" + base + "/db;MODE=MySQL");
        localConfig.set("verbindung/Username_default", "sa");
        localConfig.set("verbindung/Passwort_default", "");
        localConfig.set("verbindung/Datenbanktyp_default", "mysql");
        File userhome = CoreUtil.getWritableUserDir();
        if (!userhome.exists()) {
            userhome.mkdirs();
        }
        localConfig.set("ablauf/LogAlertLevel_default", 1);
        localConfig.set("ablauf/LogLevel_default", 2);
        localConfig.set("ablauf/basepath_default", userhome.getAbsolutePath());
        localConfig.set("ablauf/cachelifetime_default", 15);
        localConfig.set("ablauf/heartrate_default", 30);
        localConfig.set("ablauf/basepath_default", userhome.getAbsolutePath());
        String string = this.get("station/identId", null);
        if (string == null) {
            localConfig.set("station/identId", Long.toString(Timestamp.valueOf(LocalDateTime.now()).toInstant().toEpochMilli()));
        }
        if (this.get("briefe/Textmodul", null) == null) {
            localConfig.set("briefe/Textmodul", "Docx-Document");
        }
        localConfig.flush();
        LocalConfigServiceImpl.persist();
    }

    public static Hashtable<Object, Object> fold(byte[] flat) {
        return (Hashtable)LocalConfigServiceImpl.foldObject(flat);
    }

    /*
     * Exception decompiling
     */
    public static Object foldObject(byte[] flat) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

