/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.osgi;

import java.util.Collection;
import org.osgi.framework.Bundle;
import org.osgi.service.component.runtime.ServiceComponentRuntime;
import org.osgi.service.component.runtime.dto.ComponentConfigurationDTO;
import org.osgi.service.component.runtime.dto.ComponentDescriptionDTO;
import org.osgi.service.component.runtime.dto.UnsatisfiedReferenceDTO;

public class UnsatisfiedComponentUtil {
    public static String listUnsatisfiedComponents(ServiceComponentRuntime serviceComponentRuntime, Bundle ... bundles) {
        StringBuilder sb = new StringBuilder();
        Bundle[] bundleArray = bundles;
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle bundle = bundleArray[n2];
            UnsatisfiedComponentUtil._listUnsatisfiedComponents(serviceComponentRuntime, bundle, sb);
            ++n2;
        }
        return sb.toString();
    }

    private static String _collectUnsatisfiedInformation(ServiceComponentRuntime serviceComponentRuntime, Bundle bundle) {
        StringBuilder sb = new StringBuilder();
        Collection componentDescriptionDTOs = serviceComponentRuntime.getComponentDescriptionDTOs(new Bundle[]{bundle});
        for (ComponentDescriptionDTO componentDescriptionDTO : componentDescriptionDTOs) {
            Collection componentConfigurationDTOs = serviceComponentRuntime.getComponentConfigurationDTOs(componentDescriptionDTO);
            for (ComponentConfigurationDTO componentConfigurationDTO : componentConfigurationDTOs) {
                if (componentConfigurationDTO.state != 2) continue;
                UnsatisfiedComponentUtil._collectUnsatisfiedReferences(componentDescriptionDTO, componentConfigurationDTO, sb);
            }
        }
        return sb.toString();
    }

    private static void _collectUnsatisfiedReferences(ComponentDescriptionDTO componentDescriptionDTO, ComponentConfigurationDTO componentConfigurationDTO, StringBuilder sb) {
        sb.append("\n\tDeclarative Service {id: ");
        sb.append(componentConfigurationDTO.id);
        sb.append(", name: ");
        sb.append(componentDescriptionDTO.name);
        sb.append(", unsatisfied references: ");
        UnsatisfiedReferenceDTO[] unsatisfiedReferenceDTOArray = componentConfigurationDTO.unsatisfiedReferences;
        int n = componentConfigurationDTO.unsatisfiedReferences.length;
        int n2 = 0;
        while (n2 < n) {
            UnsatisfiedReferenceDTO unsatisfiedReferenceDTO = unsatisfiedReferenceDTOArray[n2];
            sb.append("\n\t\t{name: ");
            sb.append(unsatisfiedReferenceDTO.name);
            sb.append(", target: ");
            sb.append(unsatisfiedReferenceDTO.target);
            sb.append("}");
            ++n2;
        }
        sb.append("\n\t}");
    }

    private static void _listUnsatisfiedComponents(ServiceComponentRuntime serviceComponentRuntime, Bundle bundle, StringBuilder sb) {
        if (bundle.getState() != 32) {
            return;
        }
        String unsatisfiedInformation = UnsatisfiedComponentUtil._collectUnsatisfiedInformation(serviceComponentRuntime, bundle);
        if (unsatisfiedInformation.isEmpty()) {
            return;
        }
        sb.append("\nBundle {id: ");
        sb.append(bundle.getBundleId());
        sb.append(", name: ");
        sb.append(bundle.getSymbolicName());
        sb.append(", version: ");
        sb.append(bundle.getVersion());
        sb.append("}");
        sb.append(unsatisfiedInformation);
    }
}

