/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.model;

import ch.elexis.core.jpa.entities.EntityWithId;
import ch.elexis.core.jpa.entities.Kontakt;
import ch.elexis.core.jpa.model.adapter.AbstractIdDeleteModelAdapter;
import ch.elexis.core.jpa.model.adapter.AbstractIdModelAdapter;
import ch.elexis.core.model.IArticle;
import ch.elexis.core.model.IBilled;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.IPrescription;
import ch.elexis.core.model.IRecipe;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.IdentifiableWithXid;
import ch.elexis.core.model.prescription.Constants;
import ch.elexis.core.model.prescription.EntryType;
import ch.elexis.core.model.util.internal.ModelUtil;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import java.time.LocalDateTime;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class Prescription
extends AbstractIdDeleteModelAdapter<ch.elexis.core.jpa.entities.Prescription>
implements IdentifiableWithXid,
IPrescription {
    public Prescription(ch.elexis.core.jpa.entities.Prescription entity) {
        super((EntityWithId)entity);
    }

    public IPatient getPatient() {
        return ModelUtil.getAdapter((EntityWithId)((ch.elexis.core.jpa.entities.Prescription)this.getEntity()).getPatient(), IPatient.class, true);
    }

    public void setPatient(IPatient value) {
        if (value != null) {
            ((ch.elexis.core.jpa.entities.Prescription)this.getEntityMarkDirty()).setPatient((Kontakt)((AbstractIdModelAdapter)value).getEntity());
        } else {
            ((ch.elexis.core.jpa.entities.Prescription)this.getEntityMarkDirty()).setPatient(null);
        }
    }

    public IContact getPrescriptor() {
        return ModelUtil.getAdapter((EntityWithId)((ch.elexis.core.jpa.entities.Prescription)this.getEntity()).getPrescriptor(), IContact.class, true);
    }

    public void setPrescriptor(IContact value) {
        if (value != null) {
            ((ch.elexis.core.jpa.entities.Prescription)this.getEntityMarkDirty()).setPrescriptor((Kontakt)((AbstractIdModelAdapter)value).getEntity());
        } else {
            ((ch.elexis.core.jpa.entities.Prescription)this.getEntityMarkDirty()).setPrescriptor(null);
        }
    }

    public IArticle getArticle() {
        Optional article = ModelUtil.getFromStoreToString(((ch.elexis.core.jpa.entities.Prescription)this.getEntity()).getArtikel());
        if (article.isEmpty() && StringUtils.isNotBlank((CharSequence)((ch.elexis.core.jpa.entities.Prescription)this.getEntity()).getArtikelID())) {
            Optional loadedFallback = CoreModelServiceHolder.get().load(((ch.elexis.core.jpa.entities.Prescription)this.getEntity()).getArtikelID(), IArticle.class, true);
            loadedFallback.ifPresent(a -> a.setName(a.getName() + " *"));
            article = loadedFallback;
        }
        return article.orElse(null);
    }

    public void setArticle(IArticle article) {
        if (article != null) {
            Optional<String> storeToString = ModelUtil.getStoreToString((Identifiable)article);
            ((ch.elexis.core.jpa.entities.Prescription)this.getEntityMarkDirty()).setArtikel((String)storeToString.orElse(null));
        } else {
            ((ch.elexis.core.jpa.entities.Prescription)this.getEntityMarkDirty()).setArtikel(null);
        }
    }

    public LocalDateTime getDateFrom() {
        return ((ch.elexis.core.jpa.entities.Prescription)this.getEntity()).getDateFrom();
    }

    public void setDateFrom(LocalDateTime date) {
        ((ch.elexis.core.jpa.entities.Prescription)this.getEntityMarkDirty()).setDateFrom(date);
    }

    public LocalDateTime getDateTo() {
        return ((ch.elexis.core.jpa.entities.Prescription)this.getEntity()).getDateUntil();
    }

    public void setDateTo(LocalDateTime value) {
        ((ch.elexis.core.jpa.entities.Prescription)this.getEntityMarkDirty()).setDateUntil(value);
    }

    public String getDosageInstruction() {
        return StringUtils.defaultString((String)((ch.elexis.core.jpa.entities.Prescription)this.getEntity()).getDosis());
    }

    public void setDosageInstruction(String dosageInstruction) {
        ((ch.elexis.core.jpa.entities.Prescription)this.getEntityMarkDirty()).setDosis(dosageInstruction);
    }

    public String getRemark() {
        return StringUtils.defaultString((String)((ch.elexis.core.jpa.entities.Prescription)this.getEntity()).getBemerkung());
    }

    public void setRemark(String value) {
        ((ch.elexis.core.jpa.entities.Prescription)this.getEntityMarkDirty()).setBemerkung(value);
    }

    public String getStopReason() {
        return StringUtils.defaultString((String)((String)this.extInfoHandler.getExtInfo((Object)"stopReason")));
    }

    public void setStopReason(String value) {
        this.extInfoHandler.setExtInfo((Object)"stopReason", (Object)value);
    }

    public EntryType getEntryType() {
        EntryType entryType = ((ch.elexis.core.jpa.entities.Prescription)this.getEntity()).getEntryType();
        if (entryType == EntryType.UNKNOWN) {
            String rezeptId = ((ch.elexis.core.jpa.entities.Prescription)this.getEntity()).getRezeptID();
            if (rezeptId != null && !rezeptId.isEmpty()) {
                if (rezeptId.equals("Direktabgabe")) {
                    this.setEntryType(EntryType.SELF_DISPENSED);
                    ((ch.elexis.core.jpa.entities.Prescription)this.getEntityMarkDirty()).setRezeptID("");
                    CoreModelServiceHolder.get().save((Identifiable)this);
                    return EntryType.SELF_DISPENSED;
                }
                this.setEntryType(EntryType.RECIPE);
                CoreModelServiceHolder.get().save((Identifiable)this);
                return EntryType.RECIPE;
            }
            this.setEntryType(EntryType.FIXED_MEDICATION);
            CoreModelServiceHolder.get().save((Identifiable)this);
            return EntryType.FIXED_MEDICATION;
        }
        return entryType;
    }

    public void setEntryType(EntryType value) {
        ((ch.elexis.core.jpa.entities.Prescription)this.getEntityMarkDirty()).setEntryType(value);
    }

    public String getDisposalComment() {
        return StringUtils.defaultString((String)((String)this.extInfoHandler.getExtInfo((Object)"disposalComment")));
    }

    public void setDisposalComment(String value) {
        this.extInfoHandler.setExtInfo((Object)"disposalComment", (Object)value);
    }

    public int getSortOrder() {
        return ((ch.elexis.core.jpa.entities.Prescription)this.getEntity()).getSortorder();
    }

    public void setSortOrder(int value) {
        ((ch.elexis.core.jpa.entities.Prescription)this.getEntityMarkDirty()).setSortorder(value);
    }

    public boolean isApplied() {
        String value = (String)this.getExtInfo(Constants.FLD_EXT_IS_APPLIED);
        return value != null ? Boolean.valueOf(value) : false;
    }

    public void setApplied(boolean value) {
        this.setExtInfo(Constants.FLD_EXT_IS_APPLIED, Boolean.toString(value));
    }

    public IRecipe getRecipe() {
        String recipeId = ((ch.elexis.core.jpa.entities.Prescription)this.getEntity()).getRezeptID();
        if (recipeId != null && !recipeId.isEmpty()) {
            return CoreModelServiceHolder.get().load(recipeId, IRecipe.class).orElse(null);
        }
        return null;
    }

    public void setRecipe(IRecipe value) {
        if (value instanceof AbstractIdModelAdapter) {
            if (this.getRecipe() != null) {
                this.addRefresh((Identifiable)this.getRecipe());
            }
            ((ch.elexis.core.jpa.entities.Prescription)this.getEntityMarkDirty()).setRezeptID(value.getId());
            this.addRefresh((Identifiable)value);
        }
    }

    public Object getExtInfo(Object key) {
        return this.extInfoHandler.getExtInfo(key);
    }

    public void setExtInfo(Object key, Object value) {
        this.extInfoHandler.setExtInfo(key, value);
    }

    public Map<Object, Object> getMap() {
        return this.extInfoHandler.getMap();
    }

    public IBilled getBilled() {
        String billedId = (String)this.extInfoHandler.getExtInfo((Object)"verrechnetId");
        if (billedId != null && !billedId.isEmpty()) {
            return CoreModelServiceHolder.get().load(billedId, IBilled.class).orElse(null);
        }
        return null;
    }

    public void setBilled(IBilled value) {
        if (value != null) {
            this.extInfoHandler.setExtInfo((Object)"verrechnetId", (Object)value.getId());
        } else {
            this.extInfoHandler.setExtInfo((Object)"verrechnetId", null);
        }
    }

    public String getLabel() {
        return this.getSimpleLabel() + " " + this.getDosageInstruction();
    }

    private String getSimpleLabel() {
        IArticle art = this.getArticle();
        if (art != null) {
            return art.getLabel();
        }
        return "?";
    }
}

