/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.model;

import ch.elexis.core.jpa.entities.EntityWithId;
import ch.elexis.core.jpa.entities.Kontakt;
import ch.elexis.core.jpa.entities.LabItem;
import ch.elexis.core.jpa.model.adapter.AbstractIdDeleteModelAdapter;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.ILabItem;
import ch.elexis.core.model.ILabOrder;
import ch.elexis.core.model.ILabResult;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.IdentifiableWithXid;
import ch.elexis.core.model.ModelPackage;
import ch.elexis.core.model.service.holder.CoreModelServiceHolder;
import ch.elexis.core.model.util.internal.LabPathologicEvaluator;
import ch.elexis.core.model.util.internal.ModelUtil;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.types.PathologicDescription;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.emf.ecore.EStructuralFeature;

public class LabResult
extends AbstractIdDeleteModelAdapter<ch.elexis.core.jpa.entities.LabResult>
implements IdentifiableWithXid,
ILabResult {
    private LabPathologicEvaluator labPathologicEvaluator;

    public LabResult(ch.elexis.core.jpa.entities.LabResult entity) {
        super((EntityWithId)entity);
    }

    public String getUnit() {
        return ((ch.elexis.core.jpa.entities.LabResult)this.getEntity()).getUnit();
    }

    public void setUnit(String value) {
        ((ch.elexis.core.jpa.entities.LabResult)this.getEntityMarkDirty()).setUnit(value);
    }

    public LocalDateTime getAnalyseTime() {
        return ((ch.elexis.core.jpa.entities.LabResult)this.getEntity()).getAnalysetime();
    }

    public void setAnalyseTime(LocalDateTime value) {
        ((ch.elexis.core.jpa.entities.LabResult)this.getEntityMarkDirty()).setAnalysetime(value);
    }

    public LocalDateTime getObservationTime() {
        return ((ch.elexis.core.jpa.entities.LabResult)this.getEntity()).getObservationtime();
    }

    public void setObservationTime(LocalDateTime value) {
        ((ch.elexis.core.jpa.entities.LabResult)this.getEntityMarkDirty()).setObservationtime(value);
    }

    public LocalDateTime getTransmissionTime() {
        return ((ch.elexis.core.jpa.entities.LabResult)this.getEntity()).getTransmissiontime();
    }

    public void setTransmissionTime(LocalDateTime value) {
        ((ch.elexis.core.jpa.entities.LabResult)this.getEntityMarkDirty()).setTransmissiontime(value);
    }

    public boolean isPathologic() {
        return ((ch.elexis.core.jpa.entities.LabResult)this.getEntity()).isFlagged(1);
    }

    public void setPathologic(boolean value) {
        int oldFlags = ((ch.elexis.core.jpa.entities.LabResult)this.getEntity()).getFlags();
        if (value) {
            ((ch.elexis.core.jpa.entities.LabResult)this.getEntityMarkDirty()).setFlags(oldFlags | 1);
        } else {
            ((ch.elexis.core.jpa.entities.LabResult)this.getEntityMarkDirty()).setFlags(oldFlags & 0xFFFFFFFE);
        }
    }

    public String getResult() {
        return ((ch.elexis.core.jpa.entities.LabResult)this.getEntity()).getResult();
    }

    public void setResult(String value) {
        ((ch.elexis.core.jpa.entities.LabResult)this.getEntityMarkDirty()).setResult(value);
        this.setPathologic(this.getLabPathologicEvaluator().isPathologic(this));
    }

    public String getComment() {
        return ((ch.elexis.core.jpa.entities.LabResult)this.getEntity()).getComment();
    }

    public void setComment(String value) {
        ((ch.elexis.core.jpa.entities.LabResult)this.getEntityMarkDirty()).setComment(value);
    }

    public String getReferenceMale() {
        return this.resolvePreferredRefValue(this.getItem().getReferenceMale(), ((ch.elexis.core.jpa.entities.LabResult)this.getEntity()).getRefMale());
    }

    public void setReferenceMale(String value) {
        ((ch.elexis.core.jpa.entities.LabResult)this.getEntityMarkDirty()).setRefMale(value);
        this.setPathologic(this.getLabPathologicEvaluator().isPathologic(this));
    }

    public String getReferenceFemale() {
        return this.resolvePreferredRefValue(this.getItem().getReferenceFemale(), ((ch.elexis.core.jpa.entities.LabResult)this.getEntity()).getRefFemale());
    }

    public void setReferenceFemale(String value) {
        ((ch.elexis.core.jpa.entities.LabResult)this.getEntityMarkDirty()).setRefFemale(value);
        this.setPathologic(this.getLabPathologicEvaluator().isPathologic(this));
    }

    public LocalDate getDate() {
        return ((ch.elexis.core.jpa.entities.LabResult)this.getEntity()).getDate();
    }

    public void setDate(LocalDate value) {
        ((ch.elexis.core.jpa.entities.LabResult)this.getEntityMarkDirty()).setDate(value);
    }

    public ILabItem getItem() {
        CoreModelServiceHolder.get().refresh((Identifiable)this);
        return ModelUtil.getAdapter((EntityWithId)((ch.elexis.core.jpa.entities.LabResult)this.getEntity()).getItem(), ILabItem.class);
    }

    public void setItem(ILabItem value) {
        if (value instanceof AbstractIdDeleteModelAdapter) {
            ((ch.elexis.core.jpa.entities.LabResult)this.getEntityMarkDirty()).setItem((LabItem)((AbstractIdDeleteModelAdapter)value).getEntity());
        } else if (value == null) {
            ((ch.elexis.core.jpa.entities.LabResult)this.getEntityMarkDirty()).setItem(null);
        }
    }

    public PathologicDescription getPathologicDescription() {
        return ((ch.elexis.core.jpa.entities.LabResult)this.getEntity()).getPathologicDescription();
    }

    public void setPathologicDescription(PathologicDescription value) {
        ((ch.elexis.core.jpa.entities.LabResult)this.getEntityMarkDirty()).setPathologicDescription(value);
    }

    public IContact getOrigin() {
        return ModelUtil.getAdapter((EntityWithId)((ch.elexis.core.jpa.entities.LabResult)this.getEntity()).getOrigin(), IContact.class);
    }

    public void setOrigin(IContact value) {
        if (value instanceof AbstractIdDeleteModelAdapter) {
            ((ch.elexis.core.jpa.entities.LabResult)this.getEntityMarkDirty()).setOrigin((Kontakt)((AbstractIdDeleteModelAdapter)value).getEntity());
        } else if (value == null) {
            ((ch.elexis.core.jpa.entities.LabResult)this.getEntityMarkDirty()).setOrigin(null);
        }
    }

    public IPatient getPatient() {
        CoreModelServiceHolder.get().refresh((Identifiable)this);
        return ModelUtil.getAdapter((EntityWithId)((ch.elexis.core.jpa.entities.LabResult)this.getEntity()).getPatient(), IPatient.class);
    }

    public void setPatient(IPatient value) {
        if (value instanceof AbstractIdDeleteModelAdapter) {
            ((ch.elexis.core.jpa.entities.LabResult)this.getEntityMarkDirty()).setPatient((Kontakt)((AbstractIdDeleteModelAdapter)value).getEntity());
        } else if (value == null) {
            ((ch.elexis.core.jpa.entities.LabResult)this.getEntityMarkDirty()).setPatient(null);
        }
    }

    public ILabOrder getLabOrder() {
        return this.getLabOrder(false);
    }

    public ILabOrder getLabOrder(boolean includeDeleted) {
        IQuery query = includeDeleted ? CoreModelServiceHolder.get().getQuery(ILabOrder.class, true) : ModelUtil.getQuery(ILabOrder.class);
        query.and((EStructuralFeature)ModelPackage.Literals.ILAB_ORDER__RESULT, IQuery.COMPARATOR.EQUALS, (Object)this);
        return query.executeSingleResult().orElse(null);
    }

    private String resolvePreferredRefValue(String itemRef, String resultRef) {
        boolean useLocalRefs = ModelUtil.isUserConfig(ModelUtil.getActiveUserContact().orElse(null), "lab/localRefValues", true);
        if (useLocalRefs && itemRef != null && !itemRef.isEmpty()) {
            return itemRef;
        }
        String ref = StringUtils.defaultString((String)resultRef);
        if (ref.isEmpty()) {
            return itemRef;
        }
        return ref;
    }

    private synchronized LabPathologicEvaluator getLabPathologicEvaluator() {
        if (this.labPathologicEvaluator == null) {
            this.labPathologicEvaluator = new LabPathologicEvaluator();
        }
        return this.labPathologicEvaluator;
    }

    public Object getExtInfo(Object key) {
        return this.extInfoHandler.getExtInfo(key);
    }

    public void setExtInfo(Object key, Object value) {
        this.extInfoHandler.setExtInfo(key, value);
    }

    public Map<Object, Object> getMap() {
        return this.extInfoHandler.getMap();
    }

    public String getLabel() {
        return this.getItem().getLabel() + ", " + String.valueOf(this.getDate()) + ": " + this.getResult();
    }

    public String toString() {
        return super.toString() + " " + this.getLabel();
    }
}

