/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.model;

import ch.elexis.core.jpa.entities.DbImage;
import ch.elexis.core.jpa.entities.EntityWithId;
import ch.elexis.core.jpa.model.adapter.AbstractIdDeleteModelAdapter;
import ch.elexis.core.model.IImage;
import ch.elexis.core.model.IdentifiableWithXid;
import ch.elexis.core.model.MimeType;
import jakarta.persistence.Transient;
import java.time.LocalDate;
import org.apache.commons.lang3.StringUtils;

public class Image
extends AbstractIdDeleteModelAdapter<DbImage>
implements IdentifiableWithXid,
IImage {
    public Image(DbImage entity) {
        super((EntityWithId)entity);
    }

    public LocalDate getDate() {
        return ((DbImage)this.getEntity()).getDate();
    }

    public void setDate(LocalDate value) {
        ((DbImage)this.getEntityMarkDirty()).setDate(value);
    }

    public String getPrefix() {
        return ((DbImage)this.getEntity()).getPrefix();
    }

    public void setPrefix(String value) {
        ((DbImage)this.getEntityMarkDirty()).setPrefix(value);
    }

    public String getTitle() {
        return ((DbImage)this.getEntity()).getTitle();
    }

    public void setTitle(String value) {
        ((DbImage)this.getEntityMarkDirty()).setTitle(value);
    }

    public byte[] getImage() {
        return ((DbImage)this.getEntity()).getImage();
    }

    public void setImage(byte[] value) {
        ((DbImage)this.getEntityMarkDirty()).setImage(value);
    }

    public void setId(String id) {
        ((DbImage)this.getEntityMarkDirty()).setId(id);
    }

    public MimeType getMimeType() {
        int val = this.findTitleMimetypeSeparator();
        if (val != -1) {
            return MimeType.valueOf((String)this.getTitle().substring(val + 1));
        }
        return null;
    }

    public void setMimeType(MimeType value) {
        int val = this.findTitleMimetypeSeparator();
        String title = this.getTitle();
        if (val != -1) {
            title = title.substring(val);
        }
        this.setTitle(title + "." + value.name());
    }

    @Transient
    private int findTitleMimetypeSeparator() {
        String title = this.getTitle();
        if (StringUtils.isNotBlank((CharSequence)title)) {
            return title.lastIndexOf(46);
        }
        return -1;
    }
}

