/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.model;

import ch.elexis.core.jpa.entities.EntityWithId;
import ch.elexis.core.jpa.entities.TagesNachricht;
import ch.elexis.core.jpa.model.adapter.AbstractIdDeleteModelAdapter;
import ch.elexis.core.model.IDayMessage;
import ch.elexis.core.model.IdentifiableWithXid;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DayMessage
extends AbstractIdDeleteModelAdapter<TagesNachricht>
implements IdentifiableWithXid,
IDayMessage {
    private Logger log = LoggerFactory.getLogger(DayMessage.class);
    private final DateTimeFormatter yyyyMMdd = DateTimeFormatter.ofPattern("yyyyMMdd");

    public DayMessage(TagesNachricht entity) {
        super((EntityWithId)entity);
    }

    public void setId(String id) {
        ((TagesNachricht)this.getEntityMarkDirty()).setId(id);
    }

    public String getTitle() {
        return ((TagesNachricht)this.getEntity()).getKurz();
    }

    public void setTitle(String value) {
        ((TagesNachricht)this.getEntityMarkDirty()).setKurz(value);
    }

    public String getMessage() {
        return ((TagesNachricht)this.getEntity()).getMsg();
    }

    public void setMessage(String value) {
        ((TagesNachricht)this.getEntityMarkDirty()).setMsg(value);
    }

    public LocalDate getDate() {
        if (StringUtils.isNotBlank((CharSequence)this.getId())) {
            try {
                return LocalDate.parse(this.getId(), this.yyyyMMdd);
            }
            catch (DateTimeParseException e) {
                this.log.warn("Error parsing [{}]", (Object)this.getId(), (Object)e);
            }
        }
        return null;
    }

    public void setDate(LocalDate value) {
        if (value == null) {
            return;
        }
        ((TagesNachricht)this.getEntityMarkDirty()).setId(value.format(this.yyyyMMdd));
    }
}

