/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.model;

import ch.elexis.core.jpa.entities.EntityWithId;
import ch.elexis.core.jpa.entities.Heap;
import ch.elexis.core.jpa.model.adapter.AbstractIdDeleteModelAdapter;
import ch.elexis.core.jpa.model.util.JpaModelUtil;
import ch.elexis.core.model.Deleteable;
import ch.elexis.core.model.IBlob;
import ch.elexis.core.model.IdentifiableWithXid;
import java.time.LocalDate;
import java.util.Collections;
import java.util.Map;
import org.slf4j.LoggerFactory;

public class Blob
extends AbstractIdDeleteModelAdapter<Heap>
implements IdentifiableWithXid,
Deleteable,
IBlob {
    public Blob(Heap entity) {
        super((EntityWithId)entity);
    }

    public byte[] getContent() {
        return ((Heap)this.getEntity()).getInhalt();
    }

    public void setContent(byte[] value) {
        ((Heap)this.getEntityMarkDirty()).setInhalt(value);
    }

    public String getStringContent() {
        byte[] comp = this.getContent();
        if (comp == null || comp.length == 0) {
            return "";
        }
        byte[] exp = JpaModelUtil.getExpanded((byte[])comp);
        try {
            return new String(exp, "utf-8");
        }
        catch (Exception ex) {
            LoggerFactory.getLogger(this.getClass()).error("Error getting String content", (Throwable)ex);
            return null;
        }
    }

    public void setStringContent(String value) {
        byte[] comp = JpaModelUtil.getCompressed((String)value);
        this.setContent(comp);
    }

    public LocalDate getDate() {
        return ((Heap)this.getEntity()).getDatum();
    }

    public void setDate(LocalDate value) {
        ((Heap)this.getEntityMarkDirty()).setDatum(value);
    }

    public void setId(String id) {
        ((Heap)this.getEntityMarkDirty()).setId(id);
    }

    public Map<Object, Object> getMapContent() {
        byte[] comp = this.getContent();
        if (comp == null || comp.length == 0) {
            return Collections.emptyMap();
        }
        return JpaModelUtil.extInfoFromBytes((byte[])comp);
    }

    public void setMapContent(Map<Object, Object> map) {
        this.setContent(JpaModelUtil.extInfoToBytes(map));
    }
}

