/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.model.service;

import ch.elexis.core.model.IAppointment;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.ICoverage;
import ch.elexis.core.model.IOrganization;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.IPerson;
import ch.elexis.core.model.IRelatedContact;
import ch.elexis.core.model.IUserConfig;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.ModelPackage;
import ch.elexis.core.services.IElexisEntityManager;
import ch.elexis.core.services.IModelService;
import ch.elexis.core.services.INamedQuery;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.utils.OsgiServiceUtil;
import jakarta.persistence.EntityManager;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.IntStream;
import net.ttddyy.dsproxy.QueryCountHolder;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CoreModelServiceTest {
    private IModelService modelService;
    private String multiThreadPersonId;

    @Before
    public void before() {
        this.modelService = (IModelService)OsgiServiceUtil.getService(IModelService.class, (String)"(service.model.name=ch.elexis.core.model)").get();
        this.clearContacts();
    }

    @After
    public void after() {
        OsgiServiceUtil.ungetService((Object)this.modelService);
        this.modelService = null;
    }

    private void clearContacts() {
        IQuery query = this.modelService.getQuery(IContact.class, true);
        List results = query.execute();
        results.stream().forEach(c -> this.modelService.remove((Identifiable)c));
    }

    @Test
    public void createContact() {
        IContact contact = (IContact)this.modelService.create(IContact.class);
        Assert.assertNotNull((Object)contact);
        Assert.assertTrue((boolean)(contact instanceof IContact));
        contact.setDescription1("test description 1");
        contact.setDescription2("test description 2");
        this.modelService.save((Identifiable)contact);
        Optional loadedContact = this.modelService.load(contact.getId(), IContact.class);
        Assert.assertTrue((boolean)loadedContact.isPresent());
        Assert.assertFalse((contact == loadedContact.get() ? 1 : 0) != 0);
        Assert.assertEquals((Object)contact, loadedContact.get());
        Assert.assertEquals((Object)contact.getDescription1(), (Object)((IContact)loadedContact.get()).getDescription1());
    }

    @Test
    public void contactPreconditions() {
        IContact contact = (IContact)this.modelService.create(IContact.class);
        Assert.assertNotNull((Object)contact);
        Assert.assertTrue((boolean)(contact instanceof IContact));
        this.modelService.save((Identifiable)contact);
        Optional loadedContact = this.modelService.load(contact.getId(), IContact.class);
        Assert.assertTrue((boolean)loadedContact.isPresent());
        Optional loadedPerson = this.modelService.load(contact.getId(), IPerson.class);
        Assert.assertFalse((boolean)loadedPerson.isPresent());
        Optional loadedOrganization = this.modelService.load(contact.getId(), IOrganization.class);
        Assert.assertFalse((boolean)loadedOrganization.isPresent());
    }

    @Test
    public void createPatient() {
        IPatient patient = (IPatient)this.modelService.create(IPatient.class);
        Assert.assertNotNull((Object)patient);
        Assert.assertTrue((boolean)(patient instanceof IPatient));
        patient.setLastName("test lastname");
        patient.setFirstName("test first name");
        this.modelService.save((Identifiable)patient);
        Optional loadedPatient = this.modelService.load(patient.getId(), IPatient.class);
        Assert.assertTrue((boolean)loadedPatient.isPresent());
        Assert.assertFalse((patient == loadedPatient.get() ? 1 : 0) != 0);
        Assert.assertEquals((Object)patient, loadedPatient.get());
        Assert.assertTrue((boolean)patient.isPerson());
        Assert.assertTrue((boolean)patient.isPatient());
    }

    @Test
    public void castPatientToPerson() {
        IPatient patient = (IPatient)this.modelService.create(IPatient.class);
        Assert.assertNotNull((Object)patient);
        Assert.assertTrue((boolean)(patient instanceof IPatient));
        patient.setLastName("test lastname");
        patient.setFirstName("test first name");
        this.modelService.save((Identifiable)patient);
        Optional asPerson = this.modelService.cast((Identifiable)patient, IPerson.class);
        Assert.assertEquals((Object)"test lastname", (Object)((IPerson)asPerson.get()).getLastName());
    }

    @Test(expected=IllegalStateException.class)
    public void castFailPatientToICoverage() {
        IPatient patient = (IPatient)this.modelService.create(IPatient.class);
        Assert.assertNotNull((Object)patient);
        Assert.assertTrue((boolean)(patient instanceof IPatient));
        patient.setLastName("test lastname");
        patient.setFirstName("test first name");
        this.modelService.save((Identifiable)patient);
        this.modelService.cast((Identifiable)patient, ICoverage.class);
    }

    @Test
    public void createPerson() {
        IPerson person = (IPerson)this.modelService.create(IPerson.class);
        Assert.assertNotNull((Object)person);
        Assert.assertTrue((boolean)(person instanceof IPerson));
        person.setLastName("test lastname");
        person.setFirstName("test first name");
        this.modelService.save((Identifiable)person);
        Optional loadedPerson = this.modelService.load(person.getId(), IPerson.class);
        Assert.assertTrue((boolean)loadedPerson.isPresent());
        Assert.assertFalse((person == loadedPerson.get() ? 1 : 0) != 0);
        Assert.assertEquals((Object)person, loadedPerson.get());
    }

    @Test
    public void multiThreadSequential() throws InterruptedException {
        ExecutorService service = Executors.newSingleThreadExecutor();
        service.execute(new Runnable(){

            @Override
            public void run() {
                IPerson person = (IPerson)CoreModelServiceTest.this.modelService.create(IPerson.class);
                person.setLastName("test lastname");
                person.setFirstName("test first name");
                CoreModelServiceTest.this.modelService.save((Identifiable)person);
                CoreModelServiceTest.this.multiThreadPersonId = person.getId();
            }
        });
        service.execute(new Runnable(){

            @Override
            public void run() {
                Optional loadedPerson = CoreModelServiceTest.this.modelService.load(CoreModelServiceTest.this.multiThreadPersonId, IPerson.class);
                Assert.assertTrue((boolean)loadedPerson.isPresent());
            }
        });
        service.execute(new Runnable(){

            @Override
            public void run() {
                IQuery query = CoreModelServiceTest.this.modelService.getQuery(IPerson.class);
                query.and((EStructuralFeature)ModelPackage.Literals.IPERSON__LAST_NAME, IQuery.COMPARATOR.LIKE, (Object)"%lastname");
                List results = query.execute();
                Assert.assertEquals((Object)CoreModelServiceTest.this.multiThreadPersonId, (Object)((IPerson)results.get(0)).getId());
            }
        });
        service.shutdown();
        service.awaitTermination(5L, TimeUnit.SECONDS);
        this.modelService.remove((Identifiable)this.modelService.load(this.multiThreadPersonId, IPerson.class).get());
    }

    @Test
    public void multiThreadConcurrent() throws InterruptedException {
        ExecutorService service = Executors.newCachedThreadPool();
        int i = 0;
        while (i < 1000) {
            service.execute(new CreatePerson(i));
            ++i;
        }
        service.shutdown();
        service.awaitTermination(5L, TimeUnit.SECONDS);
        service = Executors.newCachedThreadPool();
        i = 0;
        while (i < 1000) {
            service.execute(new QueryPerson(i));
            ++i;
        }
        service.shutdown();
        service.awaitTermination(5L, TimeUnit.SECONDS);
        service = Executors.newCachedThreadPool();
        i = 0;
        while (i < 1000) {
            service.execute(new RemovePerson(i));
            ++i;
        }
        service.shutdown();
        service.awaitTermination(5L, TimeUnit.SECONDS);
        IQuery query = this.modelService.getQuery(IPerson.class);
        query.and((EStructuralFeature)ModelPackage.Literals.IPERSON__LAST_NAME, IQuery.COMPARATOR.LIKE, (Object)"%lastname %");
        List results = query.execute();
        Assert.assertTrue((boolean)results.isEmpty());
    }

    @Test
    public void multiThreadedNoRefreshCacheOnEmptyResult() throws InterruptedException {
        IPerson owner = (IPerson)this.modelService.create(IPerson.class);
        this.modelService.save((Identifiable)owner);
        INamedQuery configQueryA = this.modelService.getNamedQuery(IUserConfig.class, false, new String[]{"ownerid", "param"});
        configQueryA.executeWithParameters(configQueryA.getParameterMap(new Object[]{"ownerid", owner.getId(), "param", "I_DO_NOT_EXIST_THEREFORE_I_NOT_AM"}));
        Thread.sleep(50L);
        AtomicLong selectCount = new AtomicLong();
        IntStream stream = IntStream.range(0, 100);
        stream.parallel().forEach(val -> {
            long start = QueryCountHolder.getGrandTotal().getSelect();
            INamedQuery configQuery = this.modelService.getNamedQuery(IUserConfig.class, false, new String[]{"ownerid", "param"});
            List configs = configQuery.executeWithParameters(configQuery.getParameterMap(new Object[]{"ownerid", owner.getId(), "param", "I_DO_NOT_EXIST_THEREFORE_I_NOT_AM"}));
            Assert.assertEquals((long)0L, (long)configs.size());
            selectCount.addAndGet(QueryCountHolder.getGrandTotal().getSelect() - start);
        });
        Assert.assertEquals((long)0L, (long)selectCount.get());
        stream = IntStream.range(0, 100);
        stream.parallel().forEach(val -> {
            long start = QueryCountHolder.getGrandTotal().getSelect();
            INamedQuery configQuery = this.modelService.getNamedQuery(IUserConfig.class, false, new String[]{"ownerid", "param"});
            Optional config = configQuery.executeWithParametersSingleResult(configQuery.getParameterMap(new Object[]{"ownerid", owner.getId(), "param", "I_DO_NOT_EXIST_THEREFORE_I_NOT_AM"}));
            Assert.assertTrue((!config.isPresent() ? 1 : 0) != 0);
            selectCount.addAndGet(QueryCountHolder.getGrandTotal().getSelect() - start);
        });
        Assert.assertEquals((long)0L, (long)selectCount.get());
        long start = QueryCountHolder.getGrandTotal().getSelect();
        INamedQuery configQuery = this.modelService.getNamedQuery(IUserConfig.class, true, new String[]{"ownerid", "param"});
        configQuery.executeWithParametersSingleResult(configQuery.getParameterMap(new Object[]{"ownerid", owner.getId(), "param", "I_DO_NOT_EXIST_THEREFORE_I_NOT_AM"}));
        selectCount.addAndGet(QueryCountHolder.getGrandTotal().getSelect() - start);
        Assert.assertEquals((long)1L, (long)selectCount.get());
    }

    @Test
    public void refreshCacheUserConfig() throws InterruptedException {
        IPerson owner = (IPerson)this.modelService.create(IPerson.class);
        owner.setLastName("test lastname 1");
        owner.setFirstName("test first name 1");
        this.modelService.save((Identifiable)owner);
        IUserConfig config1 = (IUserConfig)this.modelService.create(IUserConfig.class);
        config1.setOwner((IContact)owner);
        config1.setKey("test key 1");
        config1.setValue("test value 1");
        this.modelService.save((Identifiable)config1);
        ExecutorService executor = Executors.newSingleThreadExecutor();
        executor.execute(new Runnable(){

            @Override
            public void run() {
                int affected = CoreModelServiceTest.this.modelService.executeNativeUpdate("UPDATE userconfig SET value = 'test value', lastupdate = 1 WHERE param = 'test key 1'", false);
                Assert.assertEquals((long)1L, (long)affected);
            }
        });
        executor.shutdown();
        executor.awaitTermination(1000L, TimeUnit.MILLISECONDS);
        INamedQuery configQuery = this.modelService.getNamedQuery(IUserConfig.class, false, new String[]{"ownerid", "param"});
        List configs = configQuery.executeWithParameters(configQuery.getParameterMap(new Object[]{"ownerid", owner.getId(), "param", "test key 1"}));
        Assert.assertEquals((long)1L, (long)configs.size());
        Assert.assertEquals((Object)"test value 1", (Object)((IUserConfig)configs.get(0)).getValue());
        configQuery = this.modelService.getNamedQuery(IUserConfig.class, true, new String[]{"ownerid", "param"});
        configs = configQuery.executeWithParameters(configQuery.getParameterMap(new Object[]{"ownerid", owner.getId(), "param", "test key 1"}));
        Assert.assertEquals((long)1L, (long)configs.size());
        Assert.assertEquals((Object)"test value", (Object)((IUserConfig)configs.get(0)).getValue());
        int i = 0;
        while (i < 100) {
            final String updateStatement = "UPDATE userconfig SET value = 'test value " + Integer.toString(i) + "', lastupdate = 1 WHERE param = 'test key 1'";
            executor = Executors.newSingleThreadExecutor();
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    int affected = CoreModelServiceTest.this.modelService.executeNativeUpdate(updateStatement, false);
                    Assert.assertEquals((long)1L, (long)affected);
                }
            });
            executor.shutdown();
            executor.awaitTermination(1000L, TimeUnit.MILLISECONDS);
            configQuery = this.modelService.getNamedQuery(IUserConfig.class, true, new String[]{"ownerid", "param"});
            configs = configQuery.executeWithParameters(configQuery.getParameterMap(new Object[]{"ownerid", owner.getId(), "param", "test key 1"}));
            Assert.assertEquals((long)1L, (long)configs.size());
            Assert.assertEquals((Object)("test value " + Integer.toString(i)), (Object)((IUserConfig)configs.get(0)).getValue());
            ++i;
        }
    }

    @Test
    public void updateRefreshPatient() {
        IPatient patient = (IPatient)this.modelService.create(IPatient.class);
        patient.setFirstName("Max");
        patient.setLastName("Mustermann");
        this.modelService.save((Identifiable)patient);
        IPatient dbP1 = (IPatient)this.modelService.load(patient.getId(), IPatient.class).get();
        Assert.assertEquals((Object)patient, (Object)dbP1);
        patient.setLastName("Mustermann1");
        Assert.assertEquals((Object)"Mustermann", (Object)dbP1.getLastName());
        Assert.assertEquals((Object)"Mustermann1", (Object)patient.getLastName());
        this.modelService.save((Identifiable)patient);
        Assert.assertEquals((Object)"Mustermann1", (Object)dbP1.getLastName());
        Assert.assertEquals((Object)"Mustermann1", (Object)patient.getLastName());
    }

    @Test
    public void deepCascadedRefresh() {
        IContact contact = (IContact)this.modelService.create(IContact.class);
        contact.setDescription1("testContact");
        this.modelService.save((Identifiable)contact);
        IRelatedContact relatedContact1 = (IRelatedContact)this.modelService.create(IRelatedContact.class);
        relatedContact1.setMyContact(contact);
        IRelatedContact relatedContact2 = (IRelatedContact)this.modelService.create(IRelatedContact.class);
        relatedContact2.setMyContact(contact);
        this.modelService.save(Arrays.asList(relatedContact1, relatedContact2));
        Assert.assertEquals((long)2L, (long)contact.getRelatedContacts().size());
        EntityManager em = (EntityManager)((IElexisEntityManager)OsgiServiceUtil.getService(IElexisEntityManager.class).get()).getEntityManager(true);
        em.getTransaction().begin();
        int executeUpdate = em.createNativeQuery("UPDATE kontakt_adress_joint SET DELETED='1' WHERE ID='" + relatedContact2.getId() + "'").executeUpdate();
        Assert.assertEquals((long)1L, (long)executeUpdate);
        em.getTransaction().commit();
        Assert.assertEquals((long)2L, (long)contact.getRelatedContacts().size());
        Assert.assertTrue((boolean)contact.getRelatedContacts().contains(relatedContact2));
        this.modelService.refresh((Identifiable)contact, true);
        Assert.assertEquals((long)1L, (long)contact.getRelatedContacts().size());
        Assert.assertFalse((boolean)contact.getRelatedContacts().contains(relatedContact2));
    }

    @Test
    public void getLastUpdate() throws InterruptedException {
        IPatient patient = (IPatient)this.modelService.create(IPatient.class);
        patient.setFirstName("Max");
        patient.setLastName("Mustermann");
        this.modelService.save((Identifiable)patient);
        long lastUpdate = this.modelService.getHighestLastUpdate(IPatient.class);
        Assert.assertTrue((lastUpdate != 0L ? 1 : 0) != 0);
        Thread.sleep(5L);
        patient.setFirstName("Maxi");
        this.modelService.save((Identifiable)patient);
        long modifiedlastUpdate = this.modelService.getHighestLastUpdate(IPatient.class);
        Assert.assertTrue((modifiedlastUpdate != 0L ? 1 : 0) != 0);
        Assert.assertTrue((modifiedlastUpdate > lastUpdate ? 1 : 0) != 0);
    }

    @Test
    public void getLastUpdateOnEmptyTable() {
        long lastUpdate = this.modelService.getHighestLastUpdate(IAppointment.class);
        Assert.assertTrue((lastUpdate == 0L ? 1 : 0) != 0);
    }

    private class CreatePerson
    implements Runnable {
        private int index;

        public CreatePerson(int index) {
            this.index = index;
        }

        @Override
        public void run() {
            IPerson person = (IPerson)CoreModelServiceTest.this.modelService.create(IPerson.class);
            person.setLastName("test lastname " + this.index);
            person.setFirstName("test first name " + this.index);
            CoreModelServiceTest.this.modelService.save((Identifiable)person);
        }
    }

    private class QueryPerson
    implements Runnable {
        private int index;

        public QueryPerson(int index) {
            this.index = index;
        }

        @Override
        public void run() {
            IQuery query = CoreModelServiceTest.this.modelService.getQuery(IPerson.class);
            query.and((EStructuralFeature)ModelPackage.Literals.IPERSON__LAST_NAME, IQuery.COMPARATOR.LIKE, (Object)("%lastname " + this.index));
            List results = query.execute();
            Assert.assertEquals((long)1L, (long)results.size());
        }
    }

    private class RemovePerson
    implements Runnable {
        private int index;

        public RemovePerson(int index) {
            this.index = index;
        }

        @Override
        public void run() {
            IQuery query = CoreModelServiceTest.this.modelService.getQuery(IPerson.class);
            query.and((EStructuralFeature)ModelPackage.Literals.IPERSON__LAST_NAME, IQuery.COMPARATOR.LIKE, (Object)("%lastname " + this.index));
            List results = query.execute();
            Assert.assertEquals((long)1L, (long)results.size());
            CoreModelServiceTest.this.modelService.remove((Identifiable)results.get(0));
        }
    }
}

