/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.model;

import ch.elexis.core.model.IContact;
import ch.elexis.core.model.IRole;
import ch.elexis.core.model.IUser;
import ch.elexis.core.model.IUserGroup;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.builder.IUserBuilder;
import ch.elexis.core.model.builder.IUserGroupBuilder;
import ch.elexis.core.services.INativeQuery;
import ch.elexis.core.test.AbstractTest;
import java.util.Iterator;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class UserGroupTest
extends AbstractTest {
    private IUser userOne;
    private IUser userTwo;
    private IRole userRole;
    private IRole testRole;

    @Before
    public void before() {
        super.before();
        super.createPerson();
        this.userRole = (IRole)this.coreModelService.create(IRole.class);
        this.userRole.setSystemRole(true);
        this.userRole.setId("user");
        this.coreModelService.save((Identifiable)this.userRole);
        this.testRole = (IRole)this.coreModelService.create(IRole.class);
        this.testRole.setSystemRole(false);
        this.testRole.setId("testRole");
        this.coreModelService.save((Identifiable)this.testRole);
        this.userOne = (IUser)new IUserBuilder(this.coreModelService, "userOne", (IContact)this.person).buildAndSave();
        this.userTwo = (IUser)new IUserBuilder(this.coreModelService, "userTwo", (IContact)this.person).build();
        this.userTwo.addRole(this.testRole);
        this.coreModelService.save((Identifiable)this.userTwo);
    }

    @After
    public void after() {
        this.coreModelService.remove((Identifiable)this.userRole);
        this.coreModelService.remove((Identifiable)this.testRole);
        this.coreModelService.remove((Identifiable)this.userOne);
        this.coreModelService.remove((Identifiable)this.userTwo);
        super.after();
    }

    @Test
    public void createFindRemove() {
        new IUserGroupBuilder(this.coreModelService, "test").buildAndSave();
        IUserGroup userGroup = (IUserGroup)this.coreModelService.load("test", IUserGroup.class).get();
        Assert.assertEquals((Object)"test", (Object)userGroup.getGroupname());
        Assert.assertTrue((boolean)userGroup.getRoles().contains(this.coreModelService.load("user", IRole.class).get()));
        this.coreModelService.remove((Identifiable)userGroup);
        Assert.assertFalse((boolean)this.coreModelService.load("test", IUserGroup.class).isPresent());
    }

    @Test
    public void query() {
        IUserGroup userGroup = (IUserGroup)new IUserGroupBuilder(this.coreModelService, "test").buildAndSave();
        userGroup.addUser(this.userOne);
        this.coreModelService.save((Identifiable)userGroup);
        INativeQuery nativeQuery = this.coreModelService.getNativeQuery("SELECT USERGROUP_ID FROM USERGROUP_USER_JOINT WHERE ID = ?1");
        Iterator result = nativeQuery.executeWithParameters(nativeQuery.getIndexedParameterMap(new Object[]{1, this.userOne.getId()})).iterator();
        Assert.assertTrue((boolean)result.hasNext());
        result = nativeQuery.executeWithParameters(nativeQuery.getIndexedParameterMap(new Object[]{1, this.userTwo.getId()})).iterator();
        Assert.assertFalse((boolean)result.hasNext());
        this.coreModelService.remove((Identifiable)userGroup);
    }

    @Test
    public void addRemoveUser() {
        IUserGroup userGroup = (IUserGroup)new IUserGroupBuilder(this.coreModelService, "test").buildAndSave();
        Assert.assertFalse((boolean)userGroup.getUsers().contains(this.userOne));
        Assert.assertFalse((boolean)userGroup.getUsers().contains(this.userTwo));
        userGroup.addUser(this.userOne);
        this.coreModelService.save((Identifiable)userGroup);
        userGroup = (IUserGroup)this.coreModelService.load(userGroup.getId(), IUserGroup.class).get();
        Assert.assertTrue((boolean)userGroup.getUsers().contains(this.userOne));
        Assert.assertFalse((boolean)userGroup.getUsers().contains(this.userTwo));
        userGroup.removeUser(this.userOne);
        this.coreModelService.save((Identifiable)userGroup);
        userGroup = (IUserGroup)this.coreModelService.load(userGroup.getId(), IUserGroup.class).get();
        Assert.assertFalse((boolean)userGroup.getUsers().contains(this.userOne));
        Assert.assertFalse((boolean)userGroup.getUsers().contains(this.userTwo));
        this.coreModelService.remove((Identifiable)userGroup);
    }

    @Test
    public void addRemoveRole() {
        IUserGroup userGroup = (IUserGroup)new IUserGroupBuilder(this.coreModelService, "test").buildAndSave();
        Assert.assertFalse((boolean)userGroup.getRoles().contains(this.testRole));
        Assert.assertTrue((boolean)userGroup.getRoles().contains(this.userRole));
        userGroup.addRole(this.testRole);
        this.coreModelService.save((Identifiable)userGroup);
        userGroup = (IUserGroup)this.coreModelService.load(userGroup.getId(), IUserGroup.class).get();
        Assert.assertTrue((boolean)userGroup.getRoles().contains(this.testRole));
        Assert.assertTrue((boolean)userGroup.getRoles().contains(this.userRole));
        userGroup.removeRole(this.testRole);
        this.coreModelService.save((Identifiable)userGroup);
        userGroup = (IUserGroup)this.coreModelService.load(userGroup.getId(), IUserGroup.class).get();
        Assert.assertFalse((boolean)userGroup.getRoles().contains(this.testRole));
        Assert.assertTrue((boolean)userGroup.getRoles().contains(this.userRole));
        this.coreModelService.remove((Identifiable)userGroup);
    }
}

