/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.model;

import ch.elexis.core.model.IPrescription;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.builder.IPrescriptionBuilder;
import ch.elexis.core.model.prescription.EntryType;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.test.AbstractTest;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.List;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PrescriptionTest
extends AbstractTest {
    @Before
    public void before() {
        super.before();
        this.createPatient();
        this.createLocalArticle();
    }

    @After
    public void after() {
        super.after();
    }

    @Test
    public void createFindDelete() {
        IPrescription prescription = (IPrescription)new IPrescriptionBuilder(this.coreModelService, null, this.localArticle, this.patient, "1-0-0-1").buildAndSave();
        Assert.assertEquals((Object)this.patient, (Object)prescription.getPatient());
        Assert.assertEquals((Object)this.localArticle, (Object)prescription.getArticle());
        Assert.assertEquals((Object)"1-0-0-1", (Object)prescription.getDosageInstruction());
        Assert.assertNotNull((Object)prescription.getDateFrom());
        Assert.assertEquals((Object)EntryType.FIXED_MEDICATION, (Object)prescription.getEntryType());
        List prescriptions = this.coreModelService.getQuery(IPrescription.class).execute();
        Assert.assertEquals((Object)prescription, prescriptions.get(0));
        this.coreModelService.remove((Identifiable)prescription);
    }

    @Test
    public void patientGetMedication() {
        IPrescription prescription = (IPrescription)new IPrescriptionBuilder(this.coreModelService, null, this.localArticle, this.patient, "1-0-0-1").buildAndSave();
        Assert.assertEquals((Object)this.patient, (Object)prescription.getPatient());
        Assert.assertEquals((Object)this.localArticle, (Object)prescription.getArticle());
        Assert.assertEquals((Object)"1-0-0-1", (Object)prescription.getDosageInstruction());
        Assert.assertNotNull((Object)prescription.getDateFrom());
        Assert.assertEquals((Object)EntryType.FIXED_MEDICATION, (Object)prescription.getEntryType());
        List medication = this.patient.getMedication(Arrays.asList(EntryType.FIXED_MEDICATION));
        Assert.assertNotNull((Object)medication);
        Assert.assertFalse((boolean)medication.isEmpty());
        medication = this.patient.getMedication(Arrays.asList(EntryType.SYMPTOMATIC_MEDICATION));
        Assert.assertNotNull((Object)medication);
        Assert.assertTrue((boolean)medication.isEmpty());
        prescription.setDateTo(LocalDateTime.now().minusSeconds(1L));
        CoreModelServiceHolder.get().save((Identifiable)prescription);
        medication = this.patient.getMedication(Arrays.asList(EntryType.FIXED_MEDICATION));
        Assert.assertNotNull((Object)medication);
        Assert.assertTrue((boolean)medication.isEmpty());
        this.coreModelService.remove((Identifiable)prescription);
    }
}

