/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.model;

import ch.elexis.core.model.Deleteable;
import ch.elexis.core.model.IBillable;
import ch.elexis.core.model.IBilled;
import ch.elexis.core.model.ICoverage;
import ch.elexis.core.model.ICustomService;
import ch.elexis.core.model.IDiagnosis;
import ch.elexis.core.model.IDiagnosisReference;
import ch.elexis.core.model.IEncounter;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.ModelPackage;
import ch.elexis.core.model.builder.ICoverageBuilder;
import ch.elexis.core.model.builder.IEncounterBuilder;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.test.AbstractTest;
import ch.rgw.tools.Money;
import ch.rgw.tools.Result;
import ch.rgw.tools.VersionedResource;
import java.time.LocalDate;
import java.time.Month;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class EncounterTest
extends AbstractTest {
    @Before
    public void before() {
        super.before();
        super.createUserSetActiveInContext();
        super.createMandator();
        super.createPatient();
        super.createCoverage();
    }

    @After
    public void after() {
        super.after();
    }

    @Test
    public void createFindDeleteEncounter() {
        IEncounter encounter = (IEncounter)new IEncounterBuilder(this.coreModelService, this.coverage, this.mandator).buildAndSave();
        LocalDate date = LocalDate.of(2018, Month.SEPTEMBER, 21);
        encounter.setDate(date);
        VersionedResource vr = VersionedResource.load(null);
        vr.update("Test consultation\nWith some test text.", "Administrator");
        vr.update("Test consultation\n pdate done by user", "user");
        encounter.setVersionedEntry(vr);
        this.coreModelService.save((Identifiable)encounter);
        IQuery query = this.coreModelService.getQuery(IEncounter.class);
        query.and((EStructuralFeature)ModelPackage.Literals.IENCOUNTER__COVERAGE, IQuery.COMPARATOR.EQUALS, (Object)this.coverage);
        Assert.assertEquals((Object)encounter, query.executeSingleResult().get());
        Assert.assertEquals((Object)date, (Object)encounter.getDate());
        Assert.assertTrue((String)encounter.getVersionedEntry().getHead(), (boolean)encounter.getVersionedEntry().getHead().contains("done by user"));
        this.coreModelService.delete((Deleteable)encounter);
    }

    @Test
    public void addRemoveDiagnosis() {
        IEncounter encounter = (IEncounter)new IEncounterBuilder(this.coreModelService, this.coverage, this.mandator).buildAndSave();
        IDiagnosisReference diagnosis = (IDiagnosisReference)this.coreModelService.create(IDiagnosisReference.class);
        diagnosis.setCode("test");
        this.coreModelService.save((Identifiable)diagnosis);
        IDiagnosisReference diagnosis1 = (IDiagnosisReference)this.coreModelService.create(IDiagnosisReference.class);
        diagnosis.setCode("test1");
        this.coreModelService.save((Identifiable)diagnosis1);
        encounter.addDiagnosis((IDiagnosis)diagnosis);
        encounter.addDiagnosis((IDiagnosis)diagnosis1);
        this.coreModelService.save((Identifiable)encounter);
        Optional loaded = this.coreModelService.load(encounter.getId(), IEncounter.class);
        Assert.assertEquals(loaded.get(), (Object)encounter);
        Assert.assertEquals((long)encounter.getDiagnoses().size(), (long)((IEncounter)loaded.get()).getDiagnoses().size());
        encounter.removeDiagnosis((IDiagnosis)diagnosis1);
        this.coreModelService.save((Identifiable)encounter);
        loaded = this.coreModelService.load(encounter.getId(), IEncounter.class);
        Assert.assertEquals(loaded.get(), (Object)encounter);
        Assert.assertEquals((long)encounter.getDiagnoses().size(), (long)((IEncounter)loaded.get()).getDiagnoses().size());
        encounter.removeDiagnosis((IDiagnosis)diagnosis);
        this.coreModelService.save((Identifiable)encounter);
        loaded = this.coreModelService.load(encounter.getId(), IEncounter.class);
        Assert.assertEquals(loaded.get(), (Object)encounter);
        Assert.assertTrue((boolean)((IEncounter)loaded.get()).getDiagnoses().isEmpty());
        this.coreModelService.remove((Identifiable)diagnosis);
        this.coreModelService.remove((Identifiable)diagnosis1);
        this.coreModelService.remove((Identifiable)encounter);
    }

    @Test
    public void addRemoveBilled() {
        ICustomService service = (ICustomService)this.coreModelService.create(ICustomService.class);
        service.setCode("12.34");
        service.setNetPrice(new Money(1));
        service.setPrice(new Money(2));
        service.setText("test");
        this.coreModelService.save((Identifiable)service);
        IEncounter encounter = (IEncounter)new IEncounterBuilder(this.coreModelService, this.coverage, this.mandator).buildAndSave();
        this.coreModelService.save((Identifiable)encounter);
        Result result = service.getOptifier().add((IBillable)service, encounter, 1.5);
        Assert.assertTrue((boolean)result.isOK());
        Assert.assertFalse((boolean)encounter.getBilled().isEmpty());
        Optional loaded = this.coreModelService.load(encounter.getId(), IEncounter.class);
        Assert.assertEquals(loaded.get(), (Object)encounter);
        Assert.assertFalse((boolean)((IEncounter)loaded.get()).getBilled().isEmpty());
        IBilled billed = (IBilled)((IEncounter)loaded.get()).getBilled().get(0);
        Assert.assertEquals((double)1.5, (double)billed.getAmount(), (double)0.01);
        Assert.assertEquals((Object)service.getText(), (Object)billed.getText());
        Assert.assertEquals((Object)service, (Object)billed.getBillable());
        encounter.removeBilled(billed);
        Assert.assertFalse((boolean)encounter.getBilled().contains(billed));
        Assert.assertTrue((boolean)billed.isDeleted());
        this.coreModelService.remove((Identifiable)service);
        this.coreModelService.remove((Identifiable)encounter);
    }

    @Test
    public void modifyBilled() {
        ICustomService service = (ICustomService)this.coreModelService.create(ICustomService.class);
        service.setCode("12.34");
        service.setNetPrice(new Money(1));
        service.setPrice(new Money(2));
        service.setText("test");
        this.coreModelService.save((Identifiable)service);
        IEncounter encounter = (IEncounter)new IEncounterBuilder(this.coreModelService, this.coverage, this.mandator).buildAndSave();
        this.coreModelService.save((Identifiable)encounter);
        Result result = service.getOptifier().add((IBillable)service, encounter, 1.5);
        Assert.assertTrue((boolean)result.isOK());
        IBilled billed = (IBilled)encounter.getBilled().get(0);
        Assert.assertEquals((double)1.5, (double)billed.getAmount(), (double)0.01);
        billed.setText("changed text");
        this.coreModelService.save((Identifiable)billed);
        result = service.getOptifier().add((IBillable)service, encounter, 1.5);
        Assert.assertEquals((double)3.0, (double)billed.getAmount(), (double)0.01);
        billed = (IBilled)encounter.getBilled().get(0);
        Assert.assertEquals((double)3.0, (double)billed.getAmount(), (double)0.01);
        this.coreModelService.remove((Identifiable)service);
        this.coreModelService.remove((Identifiable)encounter);
    }

    @Test
    public void multiThreadMappedProperties() throws InterruptedException {
        IEncounter encounter = (IEncounter)new IEncounterBuilder(this.coreModelService, this.coverage, this.mandator).buildAndSave();
        this.coreModelService.save((Identifiable)encounter);
        ExecutorService executor = Executors.newFixedThreadPool(3);
        int i = 0;
        while (i < 100) {
            int number = i++;
            executor.execute(() -> {
                this.contextService.setActiveUser(this.user);
                ICustomService service = (ICustomService)this.coreModelService.create(ICustomService.class);
                service.setCode("code" + number);
                service.setNetPrice(new Money(number));
                service.setPrice(new Money(number));
                service.setText("test" + number);
                this.coreModelService.save((Identifiable)service);
                Result result = service.getOptifier().add((IBillable)service, encounter, 1.0);
                Assert.assertNotNull((Object)result);
                Assert.assertTrue((boolean)result.isOK());
            });
            executor.execute(() -> {
                if (!encounter.getVersionedEntry().update("Test consultation\nmulti billing " + number, "Administrator")) {
                    Assert.fail();
                }
                this.coreModelService.save((Identifiable)encounter);
            });
        }
        executor.shutdown();
        executor.awaitTermination(5L, TimeUnit.SECONDS);
        int retryCount = 50;
        while (encounter.getBilled().size() < 100 && --retryCount > 0) {
            Thread.sleep(100L);
            this.coreModelService.refresh((Identifiable)encounter, true);
        }
        Assert.assertEquals((long)100L, (long)encounter.getBilled().size());
        Assert.assertTrue((encounter.getLastupdate() > 0L ? 1 : 0) != 0);
        for (IBilled billed : encounter.getBilled()) {
            Assert.assertTrue((billed.getLastupdate() > 0L ? 1 : 0) != 0);
        }
        this.coreModelService.remove((Identifiable)encounter);
        IQuery query = this.coreModelService.getQuery(ICustomService.class);
        for (ICustomService service : query.execute()) {
            this.coreModelService.remove((Identifiable)service);
        }
    }

    @Test
    public void changeCoverage() {
        IEncounter encounter = (IEncounter)new IEncounterBuilder(this.coreModelService, this.coverage, this.mandator).buildAndSave();
        LocalDate date = LocalDate.of(2018, Month.SEPTEMBER, 21);
        encounter.setDate(date);
        this.coreModelService.save((Identifiable)encounter);
        IEncounter encounter1 = (IEncounter)new IEncounterBuilder(this.coreModelService, this.coverage, this.mandator).buildAndSave();
        LocalDate date1 = LocalDate.of(2018, Month.SEPTEMBER, 22);
        encounter.setDate(date1);
        this.coreModelService.save((Identifiable)encounter1);
        Assert.assertEquals((long)2L, (long)this.coverage.getEncounters().size());
        ICoverage coverage1 = new ICoverageBuilder(this.coreModelService, this.patient, "testCoverage1", "testReason1", "testBillingSystem1").buildAndSave();
        encounter1.setCoverage(coverage1);
        this.coreModelService.save((Identifiable)encounter1);
        Assert.assertEquals((long)1L, (long)coverage1.getEncounters().size());
        Assert.assertEquals((long)1L, (long)this.coverage.getEncounters().size());
        this.coreModelService.delete((Deleteable)encounter);
    }

    @Test
    public void addAndUpdateVersionsEntry() {
        IEncounter encounter = (IEncounter)new IEncounterBuilder(this.coreModelService, this.coverage, this.mandator).buildAndSave();
        VersionedResource vr = VersionedResource.load(null);
        vr.update("TESTME", "Administrator");
        encounter.setVersionedEntry(vr);
        this.coreModelService.save((Identifiable)encounter);
        Assert.assertEquals((Object)"TESTME", (Object)encounter.getVersionedEntry().getHead());
        encounter.getVersionedEntry().update("changed", "");
        this.coreModelService.save((Identifiable)encounter);
        Assert.assertEquals((Object)"changed", (Object)encounter.getVersionedEntry().getHead());
        Assert.assertEquals((Object)"changed", (Object)((IEncounter)this.coreModelService.load(encounter.getId(), IEncounter.class).get()).getVersionedEntry().getHead());
        Assert.assertEquals((Object)"changed", (Object)((IEncounter)this.coreModelService.load(encounter.getId(), IEncounter.class, true, true).get()).getVersionedEntry().getHead());
    }
}

