/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.mediorder.mail.task;

import ch.elexis.core.mediorder.mail.task.MediorderMailIdentifiedRunnable;
import ch.elexis.core.mediorder.mail.task.MediorderMailTaskDescriptor;
import ch.elexis.core.model.tasks.IIdentifiedRunnable;
import ch.elexis.core.model.tasks.IIdentifiedRunnableFactory;
import ch.elexis.core.model.tasks.TaskException;
import ch.elexis.core.services.IAccessControlService;
import ch.elexis.core.services.IContextService;
import ch.elexis.core.services.IModelService;
import ch.elexis.core.services.IStickerService;
import ch.elexis.core.services.IStockService;
import ch.elexis.core.services.ITextReplacementService;
import ch.elexis.core.tasks.model.ITaskService;
import java.util.ArrayList;
import java.util.List;
import org.osgi.service.component.ComponentException;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true)
public class MediorderMailRunnableFactory
implements IIdentifiedRunnableFactory {
    @Reference
    private IAccessControlService accessControlService;
    @Reference
    private ITaskService taskService;
    @Reference
    private IStockService stockService;
    @Reference
    private IStickerService stickerService;
    @Reference
    private IContextService contextService;
    @Reference
    private ITextReplacementService textReplacementService;
    private IModelService coreModelService;

    @Reference(target="(service.model.name=ch.elexis.core.model)")
    private void setModelService(IModelService modelService) {
        this.coreModelService = modelService;
    }

    @Activate
    public void activate() {
        this.accessControlService.doPrivileged(() -> {
            try {
                MediorderMailTaskDescriptor.getOrCreate(this.taskService);
            }
            catch (TaskException e) {
                throw new ComponentException((Throwable)e);
            }
        });
        this.taskService.bindIIdentifiedRunnableFactory((IIdentifiedRunnableFactory)this);
    }

    @Deactivate
    public void deactivate() {
        this.taskService.unbindIIdentifiedRunnableFactory((IIdentifiedRunnableFactory)this);
    }

    public List<IIdentifiedRunnable> getProvidedRunnables() {
        ArrayList<IIdentifiedRunnable> ret = new ArrayList<IIdentifiedRunnable>();
        ret.add(new MediorderMailIdentifiedRunnable(this.coreModelService, this.contextService, this.textReplacementService, this.stockService, this.stickerService));
        return ret;
    }
}

