/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.jpa.entities.listener;

import ch.elexis.core.jpa.entities.Config;
import ch.elexis.core.jpa.entities.Kontakt;
import ch.elexis.core.jpa.entities.entitymanager.ElexisEntityManagerServiceHolder;
import jakarta.persistence.EntityManager;
import jakarta.persistence.LockModeType;
import jakarta.persistence.PrePersist;
import jakarta.persistence.PreUpdate;
import jakarta.persistence.TypedQuery;
import java.util.List;

public class KontaktEntityListener {
    @PrePersist
    public void prePersist(Kontakt contact) {
        if (contact.isPatient() && contact.getCode() == null) {
            contact.setCode(Integer.toString(this.findAndIncrementPatientNr()));
        }
    }

    @PreUpdate
    public void preUpdate(Kontakt contact) {
        if (contact.isPatient() && contact.getCode() == null) {
            contact.setCode(Integer.toString(this.findAndIncrementPatientNr()));
        }
    }

    private int findAndIncrementPatientNr() {
        int ret = 0;
        EntityManager em = (EntityManager)ElexisEntityManagerServiceHolder.getEntityManager().getEntityManager(false);
        try {
            em.getTransaction().begin();
            Config patNr = (Config)em.find(Config.class, (Object)"PatientNummer");
            if (patNr == null) {
                Config patNrConfig = new Config();
                patNrConfig.setParam("PatientNummer");
                patNrConfig.setWert("1");
                em.persist((Object)patNrConfig);
                ret = 1;
            } else {
                em.lock((Object)patNr, LockModeType.PESSIMISTIC_WRITE);
                ret = Integer.parseInt(patNr.getWert());
                ++ret;
                while (true) {
                    TypedQuery query = em.createNamedQuery("Kontakt.code", Kontakt.class);
                    query.setParameter("code", (Object)Integer.toString(ret));
                    List results = query.getResultList();
                    if (results.isEmpty()) break;
                    ++ret;
                }
                patNr.setWert(Integer.toString(ret));
            }
            em.getTransaction().commit();
            int n = ret;
            return n;
        }
        finally {
            ElexisEntityManagerServiceHolder.getEntityManager().closeEntityManager((Object)em);
        }
    }
}

