/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.jpa.entities.gson;

import ch.elexis.core.jpa.entities.AbstractEntityWithId;
import ch.elexis.core.jpa.entities.entitymanager.ElexisEntityManagerServiceHolder;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import jakarta.persistence.EntityManager;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;

public class AbstractEntityWithIdJsonAdapter
extends TypeAdapter<AbstractEntityWithId> {
    private static final String ENTITY_TYPE = "entityType";
    private static final String ID = "id";

    public void write(JsonWriter out, AbstractEntityWithId value) throws IOException {
        if (value != null) {
            out.beginObject();
            out.name(ENTITY_TYPE).value(value.getClass().getName());
            out.name(ID).value(value.getId());
            out.endObject();
        }
    }

    public AbstractEntityWithId read(JsonReader in) throws IOException {
        String entityType = null;
        String id = null;
        in.beginObject();
        while (in.hasNext()) {
            switch (in.nextName()) {
                case "entityType": {
                    entityType = in.nextString();
                    break;
                }
                case "id": {
                    id = in.nextString();
                    break;
                }
            }
        }
        in.endObject();
        return this.tryToLoad(entityType, id);
    }

    private AbstractEntityWithId tryToLoad(String entityType, String id) throws IOException {
        if (StringUtils.isNotBlank((CharSequence)entityType) && StringUtils.isNotBlank((CharSequence)id)) {
            AbstractEntityWithId abstractEntityWithId;
            Class<?> clazz = ((Object)((Object)this)).getClass().getClassLoader().loadClass(entityType);
            EntityManager em = (EntityManager)ElexisEntityManagerServiceHolder.getEntityManager().getEntityManager(true);
            try {
                AbstractEntityWithId entity = (AbstractEntityWithId)em.find(clazz, (Object)id);
                if (entity == null) {
                    throw new IOException("entityType [" + entityType + "] with id [" + id + "] not found");
                }
                abstractEntityWithId = entity;
            }
            catch (Throwable throwable) {
                try {
                    ElexisEntityManagerServiceHolder.getEntityManager().closeEntityManager((Object)em);
                    throw throwable;
                }
                catch (ClassNotFoundException e) {
                    throw new IOException(e);
                }
            }
            ElexisEntityManagerServiceHolder.getEntityManager().closeEntityManager((Object)em);
            return abstractEntityWithId;
        }
        return null;
    }
}

