/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.jpa.entities;

import ch.elexis.core.jpa.entities.AbstractEntityWithId;
import ch.elexis.core.jpa.entities.Brief;
import ch.elexis.core.jpa.entities.EntityWithDeleted;
import ch.elexis.core.jpa.entities.EntityWithId;
import ch.elexis.core.jpa.entities.Kontakt;
import ch.elexis.core.jpa.entities.Prescription;
import ch.elexis.core.jpa.entities.converter.BooleanCharacterConverterSafe;
import ch.elexis.core.jpa.entities.listener.EntityWithIdListener;
import ch.elexis.core.model.util.ElexisIdGenerator;
import jakarta.persistence.Column;
import jakarta.persistence.Convert;
import jakarta.persistence.Entity;
import jakarta.persistence.EntityListeners;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import jakarta.persistence.Table;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;

@Entity
@Table(name="rezepte")
@EntityListeners(value={EntityWithIdListener.class})
@NamedQuery(name="Rezept.patient", query="SELECT r FROM Rezept r WHERE r.deleted = false AND r.patient = :patient ORDER BY r.datum DESC, r.lastupdate DESC")
public class Rezept
extends AbstractEntityWithId
implements EntityWithId,
EntityWithDeleted,
PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedChangeTracking {
    protected Long lastupdate;
    @Id
    @Column(unique=true, nullable=false, length=25)
    private String id;
    @Column
    @Convert(converter=BooleanCharacterConverterSafe.class)
    protected boolean deleted;
    @OneToOne
    @JoinColumn(name="patientid")
    private Kontakt patient;
    @OneToOne
    @JoinColumn(name="mandantid")
    private Kontakt mandant;
    @OneToOne
    @JoinColumn(name="briefid")
    private Brief brief;
    @Column(length=8)
    private LocalDate datum;
    @OneToMany
    @JoinColumn(name="rezeptID")
    private List<Prescription> prescriptions;
    static final long serialVersionUID = 4313063334782381028L;

    public Rezept() {
        this.id = ElexisIdGenerator.generateId();
        this.deleted = false;
        this.prescriptions = new ArrayList<Prescription>();
    }

    @Override
    public boolean isDeleted() {
        return this._persistence_get_deleted();
    }

    @Override
    public void setDeleted(boolean deleted) {
        this._persistence_set_deleted(deleted);
    }

    @Override
    public String getId() {
        return this._persistence_get_id();
    }

    @Override
    public void setId(String id) {
        this._persistence_set_id(id);
    }

    @Override
    public Long getLastupdate() {
        return this._persistence_get_lastupdate();
    }

    @Override
    public void setLastupdate(Long lastupdate) {
        this._persistence_set_lastupdate(lastupdate);
    }

    public Kontakt getPatient() {
        return this._persistence_get_patient();
    }

    public void setPatient(Kontakt patient) {
        this._persistence_set_patient(patient);
    }

    public Kontakt getMandant() {
        return this._persistence_get_mandant();
    }

    public void setMandant(Kontakt mandant) {
        this._persistence_set_mandant(mandant);
    }

    public Brief getBrief() {
        return this._persistence_get_brief();
    }

    public void setBrief(Brief brief) {
        this._persistence_set_brief(brief);
    }

    public LocalDate getDatum() {
        return this._persistence_get_datum();
    }

    public void setDatum(LocalDate datum) {
        this._persistence_set_datum(datum);
    }

    public List<Prescription> getPrescriptions() {
        return this._persistence_get_prescriptions();
    }

    @Override
    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    @Override
    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new Rezept(persistenceObject);
    }

    public Rezept(PersistenceObject persistenceObject) {
        super(persistenceObject);
    }

    @Override
    public Object _persistence_get(String string) {
        if (string == "datum") {
            return this.datum;
        }
        if (string == "brief") {
            return this.brief;
        }
        if (string == "deleted") {
            return this.deleted;
        }
        if (string == "patient") {
            return this.patient;
        }
        if (string == "mandant") {
            return this.mandant;
        }
        if (string == "lastupdate") {
            return this.lastupdate;
        }
        if (string == "id") {
            return this.id;
        }
        if (string == "prescriptions") {
            return this.prescriptions;
        }
        return super._persistence_get(string);
    }

    @Override
    public void _persistence_set(String string, Object object) {
        if (string == "datum") {
            this.datum = (LocalDate)object;
            return;
        }
        if (string == "brief") {
            this.brief = (Brief)object;
            return;
        }
        if (string == "deleted") {
            this.deleted = (Boolean)object;
            return;
        }
        if (string == "patient") {
            this.patient = (Kontakt)object;
            return;
        }
        if (string == "mandant") {
            this.mandant = (Kontakt)object;
            return;
        }
        if (string == "lastupdate") {
            this.lastupdate = (Long)object;
            return;
        }
        if (string == "id") {
            this.id = (String)object;
            return;
        }
        if (string == "prescriptions") {
            this.prescriptions = (List)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public LocalDate _persistence_get_datum() {
        this._persistence_checkFetched("datum");
        return this.datum;
    }

    public void _persistence_set_datum(LocalDate localDate) {
        this._persistence_checkFetchedForSet("datum");
        this._persistence_propertyChange("datum", this.datum, localDate);
        this.datum = localDate;
    }

    public Brief _persistence_get_brief() {
        this._persistence_checkFetched("brief");
        return this.brief;
    }

    public void _persistence_set_brief(Brief brief) {
        this._persistence_checkFetchedForSet("brief");
        this._persistence_propertyChange("brief", this.brief, brief);
        this.brief = brief;
    }

    public boolean _persistence_get_deleted() {
        this._persistence_checkFetched("deleted");
        return this.deleted;
    }

    public void _persistence_set_deleted(boolean bl) {
        this._persistence_checkFetchedForSet("deleted");
        this._persistence_propertyChange("deleted", new Boolean(this.deleted), new Boolean(bl));
        this.deleted = bl;
    }

    public Kontakt _persistence_get_patient() {
        this._persistence_checkFetched("patient");
        return this.patient;
    }

    public void _persistence_set_patient(Kontakt kontakt) {
        this._persistence_checkFetchedForSet("patient");
        this._persistence_propertyChange("patient", this.patient, kontakt);
        this.patient = kontakt;
    }

    public Kontakt _persistence_get_mandant() {
        this._persistence_checkFetched("mandant");
        return this.mandant;
    }

    public void _persistence_set_mandant(Kontakt kontakt) {
        this._persistence_checkFetchedForSet("mandant");
        this._persistence_propertyChange("mandant", this.mandant, kontakt);
        this.mandant = kontakt;
    }

    public Long _persistence_get_lastupdate() {
        this._persistence_checkFetched("lastupdate");
        return this.lastupdate;
    }

    public void _persistence_set_lastupdate(Long l) {
        this._persistence_checkFetchedForSet("lastupdate");
        this._persistence_propertyChange("lastupdate", this.lastupdate, l);
        this.lastupdate = l;
    }

    public String _persistence_get_id() {
        this._persistence_checkFetched("id");
        return this.id;
    }

    public void _persistence_set_id(String string) {
        this._persistence_checkFetchedForSet("id");
        this._persistence_propertyChange("id", this.id, string);
        this.id = string;
    }

    public List _persistence_get_prescriptions() {
        this._persistence_checkFetched("prescriptions");
        return this.prescriptions;
    }

    public void _persistence_set_prescriptions(List list) {
        this._persistence_checkFetchedForSet("prescriptions");
        this._persistence_propertyChange("prescriptions", this.prescriptions, list);
        this.prescriptions = list;
    }
}

