/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.jpa.entities;

import ch.elexis.core.jpa.entities.AbstractEntityWithId;
import ch.elexis.core.jpa.entities.DbImage;
import ch.elexis.core.jpa.entities.EntityWithDeleted;
import ch.elexis.core.jpa.entities.EntityWithId;
import ch.elexis.core.jpa.entities.converter.BooleanCharacterConverterSafe;
import ch.elexis.core.jpa.entities.converter.IntegerStringConverter;
import ch.elexis.core.jpa.entities.listener.EntityWithIdListener;
import ch.elexis.core.model.util.ElexisIdGenerator;
import jakarta.persistence.Column;
import jakarta.persistence.Convert;
import jakarta.persistence.Entity;
import jakarta.persistence.EntityListeners;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import org.eclipse.persistence.annotations.Cache;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;

@Entity
@Table(name="ETIKETTEN")
@EntityListeners(value={EntityWithIdListener.class})
@Cache(expiry=15000)
public class Sticker
extends AbstractEntityWithId
implements EntityWithId,
EntityWithDeleted,
PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedChangeTracking {
    protected Long lastupdate;
    @Id
    @Column(unique=true, nullable=false, length=25)
    private String id;
    @Column
    @Convert(converter=BooleanCharacterConverterSafe.class)
    protected boolean deleted;
    @ManyToOne
    @JoinColumn(name="image")
    private DbImage image;
    @Column(length=7)
    @Convert(converter=IntegerStringConverter.class)
    private int importance;
    @Column(length=40, name="Name")
    private String name;
    @Column(columnDefinition="CHAR(6)")
    private String foreground;
    @Column(columnDefinition="CHAR(6)")
    private String background;
    @Column(length=255)
    private String classes;
    static final long serialVersionUID = -5688669768771972733L;

    public Sticker() {
        this.id = ElexisIdGenerator.generateId();
        this.deleted = false;
    }

    public DbImage getImage() {
        return this._persistence_get_image();
    }

    public void setImage(DbImage image) {
        this._persistence_set_image(image);
    }

    public int getImportance() {
        return this._persistence_get_importance();
    }

    public void setImportance(int importance) {
        this._persistence_set_importance(importance);
    }

    public String getName() {
        return this._persistence_get_name();
    }

    public void setName(String name) {
        this._persistence_set_name(name);
    }

    public String getForeground() {
        return this._persistence_get_foreground();
    }

    public void setForeground(String foreground) {
        this._persistence_set_foreground(foreground);
    }

    public String getBackground() {
        return this._persistence_get_background();
    }

    public void setBackground(String background) {
        this._persistence_set_background(background);
    }

    public String getClasses() {
        return this._persistence_get_classes();
    }

    public void setClasses(String classes) {
        this._persistence_set_classes(classes);
    }

    @Override
    public boolean isDeleted() {
        return this._persistence_get_deleted();
    }

    @Override
    public void setDeleted(boolean deleted) {
        this._persistence_set_deleted(deleted);
    }

    @Override
    public String getId() {
        return this._persistence_get_id();
    }

    @Override
    public void setId(String id) {
        this._persistence_set_id(id);
    }

    @Override
    public Long getLastupdate() {
        return this._persistence_get_lastupdate();
    }

    @Override
    public void setLastupdate(Long lastupdate) {
        this._persistence_set_lastupdate(lastupdate);
    }

    @Override
    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    @Override
    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new Sticker(persistenceObject);
    }

    public Sticker(PersistenceObject persistenceObject) {
        super(persistenceObject);
    }

    @Override
    public Object _persistence_get(String string) {
        if (string == "image") {
            return this.image;
        }
        if (string == "deleted") {
            return this.deleted;
        }
        if (string == "importance") {
            return this.importance;
        }
        if (string == "background") {
            return this.background;
        }
        if (string == "classes") {
            return this.classes;
        }
        if (string == "name") {
            return this.name;
        }
        if (string == "lastupdate") {
            return this.lastupdate;
        }
        if (string == "id") {
            return this.id;
        }
        if (string == "foreground") {
            return this.foreground;
        }
        return super._persistence_get(string);
    }

    @Override
    public void _persistence_set(String string, Object object) {
        if (string == "image") {
            this.image = (DbImage)object;
            return;
        }
        if (string == "deleted") {
            this.deleted = (Boolean)object;
            return;
        }
        if (string == "importance") {
            this.importance = (Integer)object;
            return;
        }
        if (string == "background") {
            this.background = (String)object;
            return;
        }
        if (string == "classes") {
            this.classes = (String)object;
            return;
        }
        if (string == "name") {
            this.name = (String)object;
            return;
        }
        if (string == "lastupdate") {
            this.lastupdate = (Long)object;
            return;
        }
        if (string == "id") {
            this.id = (String)object;
            return;
        }
        if (string == "foreground") {
            this.foreground = (String)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public DbImage _persistence_get_image() {
        this._persistence_checkFetched("image");
        return this.image;
    }

    public void _persistence_set_image(DbImage dbImage) {
        this._persistence_checkFetchedForSet("image");
        this._persistence_propertyChange("image", this.image, dbImage);
        this.image = dbImage;
    }

    public boolean _persistence_get_deleted() {
        this._persistence_checkFetched("deleted");
        return this.deleted;
    }

    public void _persistence_set_deleted(boolean bl) {
        this._persistence_checkFetchedForSet("deleted");
        this._persistence_propertyChange("deleted", new Boolean(this.deleted), new Boolean(bl));
        this.deleted = bl;
    }

    public int _persistence_get_importance() {
        this._persistence_checkFetched("importance");
        return this.importance;
    }

    public void _persistence_set_importance(int n) {
        this._persistence_checkFetchedForSet("importance");
        this._persistence_propertyChange("importance", new Integer(this.importance), new Integer(n));
        this.importance = n;
    }

    public String _persistence_get_background() {
        this._persistence_checkFetched("background");
        return this.background;
    }

    public void _persistence_set_background(String string) {
        this._persistence_checkFetchedForSet("background");
        this._persistence_propertyChange("background", this.background, string);
        this.background = string;
    }

    public String _persistence_get_classes() {
        this._persistence_checkFetched("classes");
        return this.classes;
    }

    public void _persistence_set_classes(String string) {
        this._persistence_checkFetchedForSet("classes");
        this._persistence_propertyChange("classes", this.classes, string);
        this.classes = string;
    }

    public String _persistence_get_name() {
        this._persistence_checkFetched("name");
        return this.name;
    }

    public void _persistence_set_name(String string) {
        this._persistence_checkFetchedForSet("name");
        this._persistence_propertyChange("name", this.name, string);
        this.name = string;
    }

    public Long _persistence_get_lastupdate() {
        this._persistence_checkFetched("lastupdate");
        return this.lastupdate;
    }

    public void _persistence_set_lastupdate(Long l) {
        this._persistence_checkFetchedForSet("lastupdate");
        this._persistence_propertyChange("lastupdate", this.lastupdate, l);
        this.lastupdate = l;
    }

    public String _persistence_get_id() {
        this._persistence_checkFetched("id");
        return this.id;
    }

    public void _persistence_set_id(String string) {
        this._persistence_checkFetchedForSet("id");
        this._persistence_propertyChange("id", this.id, string);
        this.id = string;
    }

    public String _persistence_get_foreground() {
        this._persistence_checkFetched("foreground");
        return this.foreground;
    }

    public void _persistence_set_foreground(String string) {
        this._persistence_checkFetchedForSet("foreground");
        this._persistence_propertyChange("foreground", this.foreground, string);
        this.foreground = string;
    }
}

