/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.jpa.datasource.internal;

import ch.elexis.core.common.DBConnection;
import ch.elexis.core.jpa.datasource.internal.DataSourceConnectionParser;
import ch.elexis.core.jpa.datasource.internal.ProxyPoolingDataSourceBuilder;
import ch.elexis.core.services.IElexisDataSource;
import ch.elexis.core.status.ObjectStatus;
import java.util.Hashtable;
import java.util.Optional;
import javax.sql.DataSource;
import org.eclipse.core.runtime.IStatus;
import org.osgi.framework.FrameworkUtil;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true, property={"id=default"})
public class ElexisDataSourceService
implements IElexisDataSource {
    private static DataSource currentDataSource;
    private IStatus connectionStatus;

    @Activate
    public void activate() {
        DataSourceConnectionParser dataSourceConnectionParser = new DataSourceConnectionParser();
        Optional<DBConnection> dbConnection = dataSourceConnectionParser.parseAvailableParameters();
        if (dbConnection.isPresent()) {
            this.setDBConnection(dbConnection.get(), dataSourceConnectionParser.getConfigSource());
            this.connectionStatus = new ObjectStatus(0, "ch.elexis.core.jpa.datasource", dataSourceConnectionParser.getConfigSource(), "ok", null, dbConnection);
        }
    }

    private IStatus setDBConnection(DBConnection dbConnection, int connectionSourceCode) {
        if (this.connectionStatus != null) {
            throw new IllegalStateException("connection already set - re-set not supported, please restart");
        }
        try {
            currentDataSource = ProxyPoolingDataSourceBuilder.build(dbConnection);
            Hashtable<String, String> properties = new Hashtable<String, String>();
            properties.put("id", "default");
            FrameworkUtil.getBundle(this.getClass()).getBundleContext().registerService(DataSource.class, (Object)currentDataSource, properties);
            this.connectionStatus = new ObjectStatus(0, "ch.elexis.core.jpa.datasource", connectionSourceCode, "ok", null, (Object)dbConnection);
            return this.connectionStatus;
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
            this.connectionStatus = new ObjectStatus(4, "ch.elexis.core.jpa.datasource", connectionSourceCode, e.getMessage(), (Throwable)e, (Object)dbConnection);
            return this.connectionStatus;
        }
    }

    public IStatus setDBConnection(DBConnection dbConnection) {
        return this.setDBConnection(dbConnection, 0);
    }

    public ObjectStatus getCurrentConnectionStatus() {
        if (this.connectionStatus instanceof ObjectStatus) {
            return (ObjectStatus)this.connectionStatus;
        }
        if (this.connectionStatus != null) {
            return new ObjectStatus(this.connectionStatus, null);
        }
        return null;
    }
}

