/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.hl7;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Primitive;
import ch.elexis.core.exceptions.ElexisException;
import ch.elexis.core.model.IPatient;
import ch.elexis.hl7.HL7PatientResolver;
import ch.elexis.hl7.model.ObservationMessage;
import ch.elexis.hl7.model.OrcMessage;
import ch.elexis.hl7.v26.Messages;
import ch.rgw.tools.StringTool;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HL7Reader {
    static Logger logger = LoggerFactory.getLogger(HL7Reader.class);
    protected Message message;
    protected ObservationMessage observation;
    protected IPatient pat;
    protected HL7PatientResolver patientResolver;
    private String[] abnormalFlagStartCharacters = new String[]{"-", "+", "<", ">", "L", "H", "A"};

    public HL7Reader(Message message) {
        this.message = message;
    }

    public abstract OrcMessage getOrcMessage();

    public abstract String getSender() throws ElexisException;

    public abstract ObservationMessage readObservation(HL7PatientResolver var1, boolean var2) throws ElexisException;

    protected boolean isTextOrNumeric(String valueType) {
        if (valueType.equals("ST")) {
            return true;
        }
        if (valueType.equals("TX")) {
            return true;
        }
        if (valueType.equals("FT")) {
            return true;
        }
        if (valueType.equals("NM")) {
            return true;
        }
        if (valueType.equals("SN")) {
            return true;
        }
        return valueType.equals("CE");
    }

    protected void resolvePatient(String patid, String firstName, String lastName, String birthDate) {
        String sender = null;
        try {
            sender = this.getSender();
        }
        catch (ElexisException elexisException) {
            // empty catch block
        }
        if (this.pat == null) {
            this.pat = sender != null && !sender.isEmpty() ? this.patientResolver.resolvePatient(firstName, lastName, birthDate, sender, patid) : this.patientResolver.resolvePatient(firstName, lastName, birthDate, patid);
        }
        if (this.pat == null) {
            logger.warn(Messages.HL7_PatientNotInDatabase);
        }
    }

    protected void checkConflict(String firstName, String lastName, String birthDate, String sex, String patid) {
        if (!this.patientResolver.matchPatient(this.pat, firstName, lastName, birthDate)) {
            StringBuilder sb = new StringBuilder();
            sb.append(Messages.HL7_NameConflictWithID).append("[" + this.pat.getPatientNr() + "]").append(":\n").append(Messages.HL7_Lab).append(lastName).append(" ").append(firstName).append("(").append(sex).append("),").append(birthDate).append("\n").append(Messages.HL7_Database).append(this.pat.getLabel());
            this.pat = null;
            logger.warn(sb.toString());
            this.resolvePatient(patid, firstName, lastName, birthDate);
        }
    }

    public Boolean isPathologic(String abnormalValue) {
        if (!StringTool.isNothing((Object)abnormalValue)) {
            if (abnormalValue.startsWith("N")) {
                return false;
            }
            String[] stringArray = this.abnormalFlagStartCharacters;
            int n = this.abnormalFlagStartCharacters.length;
            int n2 = 0;
            while (n2 < n) {
                String startChar = stringArray[n2];
                if (abnormalValue.startsWith(startChar)) {
                    return true;
                }
                ++n2;
            }
        }
        return null;
    }

    public IPatient getPatient() {
        return this.pat;
    }

    public Message getACK() throws HL7Exception, IOException {
        return this.message.generateACK();
    }

    public String getVersion() {
        return this.message.getVersion();
    }

    public String parseTextValue(String value) {
        String text = value;
        text = text.replaceAll("\\\\.br\\\\", "\n");
        if ((text = text.replaceAll("\\\\.BR\\\\", "\n")) != null && !text.isEmpty()) {
            return text;
        }
        return value;
    }

    public String parseFormattedTextValue(String ftValue) {
        return this.parseTextValue(ftValue);
    }

    public String extractName(Primitive nameObj) {
        String val;
        if (nameObj != null && (val = nameObj.getValue()) != null) {
            return val.trim();
        }
        return null;
    }

    public void addNameValuesToOrcMessage(Primitive firstName, Primitive secondName, OrcMessage orcMessage) {
        if (orcMessage != null) {
            String name2;
            String name = this.extractName(firstName);
            if (name != null) {
                orcMessage.getNames().add(name);
            }
            if ((name2 = this.extractName(secondName)) != null) {
                orcMessage.getNames().add(name2);
                if (name != null) {
                    orcMessage.getNames().add(name + " " + name2);
                }
            }
        }
    }
}

