/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.util.model;

import ch.elexis.core.findings.ICoding;
import ch.elexis.core.findings.IObservation;
import java.util.Objects;

public class TransientCoding
implements ICoding {
    private String system;
    private String code;
    private String display;

    public TransientCoding(String system, String code, String display) {
        this.system = system;
        this.code = code;
        this.display = display;
    }

    public TransientCoding(IObservation.ObservationCode code) {
        this.system = code.getIdentifierSystem().getSystem();
        this.code = code.getCode();
        this.display = "";
    }

    public String getSystem() {
        return this.system;
    }

    public String getCode() {
        return this.code;
    }

    public String getDisplay() {
        return this.display;
    }

    public int hashCode() {
        return Objects.hash(this.code, this.system);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TransientCoding other = (TransientCoding)obj;
        return Objects.equals(this.code, other.code) && Objects.equals(this.system, other.system);
    }
}

