/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.util.fhir.transformer.mapper;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.rest.api.SummaryEnum;
import ch.elexis.core.findings.util.fhir.MedicamentCoding;
import ch.elexis.core.findings.util.fhir.transformer.helper.FhirUtil;
import ch.elexis.core.findings.util.fhir.transformer.mapper.IdentifiableDomainResourceAttributeMapper;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.IMandator;
import ch.elexis.core.model.IVaccination;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.IModelService;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.DateTimeType;
import org.hl7.fhir.r4.model.DomainResource;
import org.hl7.fhir.r4.model.Immunization;
import org.hl7.fhir.r4.model.Type;

public class IVaccinationImmunizationAttributeMapper
implements IdentifiableDomainResourceAttributeMapper<IVaccination, Immunization> {
    private IModelService modelService;

    public IVaccinationImmunizationAttributeMapper(IModelService modelService) {
        this.modelService = modelService;
    }

    @Override
    public void elexisToFhir(IVaccination source, Immunization target, SummaryEnum summaryEnum, Set<Include> includes) {
        LocalDate dateOfAdministration;
        Coding coding;
        FhirUtil.setVersionedIdPartLastUpdatedMeta(Immunization.class, (DomainResource)target, (Identifiable)source);
        target.setStatus(Immunization.ImmunizationStatus.COMPLETED);
        target.setPatient(FhirUtil.getReference((Identifiable)source.getPatient()));
        if (source.getPerformer() != null && source.getPerformer().isMandator()) {
            IMandator mandator = (IMandator)CoreModelServiceHolder.get().load(source.getPerformer().getId(), IMandator.class).get();
            target.addPerformer().setActor(FhirUtil.getReference((Identifiable)mandator));
        }
        StringBuilder textBuilder = new StringBuilder();
        CodeableConcept vaccine = new CodeableConcept();
        String gtin = source.getArticleGtin();
        String atc = source.getArticleAtc();
        String articelLabel = source.getArticleName();
        if (gtin != null) {
            coding = vaccine.addCoding();
            coding.setSystem(MedicamentCoding.GTIN.getOid());
            coding.setCode(gtin);
            coding.setDisplay(articelLabel);
        }
        if (atc != null) {
            coding = vaccine.addCoding();
            coding.setSystem(MedicamentCoding.ATC.getOid());
            coding.setCode(atc);
        }
        vaccine.setText(articelLabel);
        textBuilder.append(articelLabel);
        vaccine.setText(textBuilder.toString());
        target.setVaccineCode(vaccine);
        target.setLotNumber(source.getLotNumber());
        if (StringUtils.isNotBlank((CharSequence)source.getIngredientsAtc())) {
            String[] parts;
            CodeableConcept reasonCode = target.addReasonCode();
            String[] stringArray = parts = source.getIngredientsAtc().split(",");
            int n = parts.length;
            int n2 = 0;
            while (n2 < n) {
                String ingredientAtc = stringArray[n2];
                Coding coding2 = reasonCode.addCoding();
                coding2.setSystem(MedicamentCoding.ATC.getOid());
                coding2.setCode(ingredientAtc);
                ++n2;
            }
        }
        if ((dateOfAdministration = source.getDateOfAdministration()) != null) {
            Date date = Date.from(dateOfAdministration.atStartOfDay().atZone(ZoneId.systemDefault()).toInstant());
            target.setOccurrence((Type)new DateTimeType(date));
        }
    }

    @Override
    public void fhirToElexis(Immunization source, IVaccination target) {
        List<String> atcCodes;
        Optional mandator = Optional.empty();
        if (source.hasPerformer() && source.getPerformerFirstRep().hasActor()) {
            mandator = this.modelService.load((String)FhirUtil.getId(source.getPerformerFirstRep().getActor()).orElse(null), IMandator.class);
        }
        if (mandator.isPresent()) {
            target.setPerformer((IContact)mandator.get());
        }
        if (source.hasOccurrenceDateTimeType()) {
            LocalDate occurance = LocalDateTime.ofInstant(((Date)source.getOccurrenceDateTimeType().getValue()).toInstant(), ZoneId.systemDefault()).toLocalDate();
            target.setDateOfAdministration(occurance);
        }
        if (source.hasLotNumber()) {
            target.setLotNumber(source.getLotNumber());
        }
        if (source.hasReasonCode() && !(atcCodes = FhirUtil.getCodesFromConceptList(MedicamentCoding.ATC.getOid(), source.getReasonCode())).isEmpty()) {
            target.setIngredientsAtc(atcCodes.stream().collect(Collectors.joining(",")));
        }
    }
}

