/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.util.fhir.transformer.mapper;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.primitive.IdDt;
import ca.uhn.fhir.rest.api.SummaryEnum;
import ch.elexis.core.findings.codes.CodingSystem;
import ch.elexis.core.findings.util.fhir.IFhirTransformerException;
import ch.elexis.core.findings.util.fhir.transformer.mapper.IdentifiableDomainResourceAttributeMapper;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.ISickCertificate;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.time.TimeUtil;
import java.time.LocalDate;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.r4.model.Annotation;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.Condition;
import org.hl7.fhir.r4.model.DateTimeType;
import org.hl7.fhir.r4.model.DomainResource;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.Type;

public class ISickCertificateConditionAttributeMapper
implements IdentifiableDomainResourceAttributeMapper<ISickCertificate, Condition> {
    @Override
    public void elexisToFhir(ISickCertificate source, Condition target, SummaryEnum summaryEnum, Set<Include> includes) {
        target.setId((IIdType)new IdDt(Condition.class.getSimpleName(), source.getId()));
        this.mapMetaData((Identifiable)source, (DomainResource)target);
        target.getCode().addCoding(new Coding("https://fhir.kbv.de/CodeSystem/KBV_CS_SFHIR_KBV_FHIR_DOKUMENTTYPE", "eAU", "eAU"));
        target.setSubject(new Reference("Patient/" + source.getPatient().getId()));
        LocalDate date = source.getDate();
        target.setRecordedDate(TimeUtil.toDate((LocalDate)date));
        LocalDate start = source.getStart();
        target.setOnset((Type)new DateTimeType(TimeUtil.toDate((LocalDate)start)));
        if (source.getEnd() != null) {
            LocalDate end = source.getEnd();
            target.setAbatement((Type)new DateTimeType(TimeUtil.toDate((LocalDate)end)));
        }
        if (StringUtils.isNotBlank((CharSequence)source.getNote())) {
            Annotation annotation = new Annotation();
            annotation.setText(source.getNote());
            target.getNote().add(annotation);
        }
        Coding reasonCoding = new Coding(CodingSystem.ELEXIS_AUF_REASON.getSystem(), source.getReason(), source.getReason());
        target.getCode().addCoding(reasonCoding);
        Coding aufDegreeCoding = new Coding(CodingSystem.ELEXIS_AUF_DEGREE.getSystem(), Integer.toString(source.getPercent()), Integer.toString(source.getPercent()) + "%");
        target.getStageFirstRep().setType(new CodeableConcept(aufDegreeCoding));
    }

    @Override
    public void fhirToElexis(Condition source, ISickCertificate target) {
        List codings;
        List reasonCodings;
        Optional patient = CoreModelServiceHolder.get().load(source.getSubject().getReferenceElement().getIdPart(), IPatient.class);
        if (patient.isEmpty()) {
            throw new IFhirTransformerException("WARNING", "Invalid patient", 412);
        }
        target.setPatient((IPatient)patient.get());
        if (source.hasRecordedDate()) {
            target.setDate(TimeUtil.toLocalDate((Date)source.getRecordedDate()));
        }
        if (source.hasOnsetDateTimeType()) {
            target.setStart(TimeUtil.toLocalDate((Date)((Date)source.getOnsetDateTimeType().getValue())));
        }
        if (source.hasAbatementDateTimeType()) {
            target.setEnd(TimeUtil.toLocalDate((Date)((Date)source.getAbatementDateTimeType().getValue())));
        }
        if (source.hasCode() && !(reasonCodings = (codings = source.getCode().getCoding()).stream().filter(c -> !"https://fhir.kbv.de/CodeSystem/KBV_CS_SFHIR_KBV_FHIR_DOKUMENTTYPE".equals(c.getSystem())).collect(Collectors.toList())).isEmpty()) {
            target.setReason(((Coding)reasonCodings.get(0)).getDisplay());
        }
        if (source.hasStage() && source.getStageFirstRep().hasType()) {
            CodeableConcept stageType = source.getStageFirstRep().getType();
            for (Coding coding : stageType.getCoding()) {
                String code;
                if (!coding.hasSystem() || !coding.getSystem().endsWith("degree") && !coding.getSystem().endsWith("percent") || !StringUtils.isNotBlank((CharSequence)(code = coding.getCode().replaceAll("%", "").trim())) || !StringUtils.isNumeric((CharSequence)code)) continue;
                target.setPercent(Integer.valueOf(code).intValue());
                break;
            }
        }
        if (source.hasNote()) {
            target.setNote(source.getNote().stream().map(n -> n.getText()).collect(Collectors.joining("\n\n")));
        }
    }
}

