/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.util.fhir.transformer.mapper;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.rest.api.SummaryEnum;
import ch.elexis.core.findings.util.fhir.transformer.helper.IPersonHelper;
import ch.elexis.core.findings.util.fhir.transformer.mapper.IdentifiableDomainResourceAttributeMapper;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.IPerson;
import java.util.Set;
import org.hl7.fhir.r4.model.RelatedPerson;

public class IPersonRelatedPersonAttributeMapper
implements IdentifiableDomainResourceAttributeMapper<IPerson, RelatedPerson> {
    private IPersonHelper personHelper = new IPersonHelper();

    @Override
    public void elexisToFhir(IPerson source, RelatedPerson target, SummaryEnum summaryEnum, Set<Include> includes) {
    }

    @Override
    public void fhirToElexis(RelatedPerson source, IPerson target) {
        this.personHelper.mapHumanName(source.getName(), target);
        this.personHelper.mapAddress(source.getAddress(), (IContact)target);
        this.personHelper.mapGender(source.getGender(), target);
        this.personHelper.mapBirthDate(source.getBirthDate(), target);
        this.personHelper.mapTelecom(source.getTelecom(), (IContact)target);
    }
}

