/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.util.fhir.transformer.helper;

import ch.elexis.core.findings.codes.CodingSystem;
import ch.elexis.core.findings.util.fhir.transformer.helper.AbstractHelper;
import ch.elexis.core.model.ILabItem;
import ch.elexis.core.model.ILabResult;
import ch.elexis.core.types.Gender;
import ch.elexis.core.types.LabItemTyp;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.hl7.fhir.r4.model.Annotation;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.DateTimeType;
import org.hl7.fhir.r4.model.Observation;
import org.hl7.fhir.r4.model.Quantity;
import org.hl7.fhir.r4.model.SimpleQuantity;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.r4.model.Type;

public class ILabResultHelper
extends AbstractHelper {
    public Type getEffectiveDateTime(ILabResult localObject) {
        if (localObject.getObservationTime() != null) {
            return new DateTimeType(this.getDate(localObject.getObservationTime()));
        }
        if (localObject.getDate() != null) {
            return new DateTimeType(this.getDate(localObject.getDate()));
        }
        return null;
    }

    public Type getResult(ILabResult localObject) {
        if (localObject.getItem().getTyp() == LabItemTyp.NUMERIC) {
            String result = localObject.getResult();
            Optional<Double> numericResult = ILabResultHelper.getNumericValue(result);
            if (numericResult.isPresent()) {
                Quantity qty = new Quantity();
                qty.setValue(numericResult.get().doubleValue());
                qty.setUnit(Optional.ofNullable(localObject.getUnit()).orElse(""));
                ILabResultHelper.getComparator(result).ifPresent(comp -> {
                    Quantity quantity2 = qty.setComparator(comp);
                });
                return qty;
            }
            return new StringType(result + " " + (localObject.getUnit() != null ? localObject.getUnit() : ""));
        }
        if (localObject.getItem().getTyp() == LabItemTyp.TEXT) {
            if (this.isLongText(localObject)) {
                String resultComment = localObject.getComment();
                return new StringType(resultComment);
            }
            return new StringType(localObject.getResult());
        }
        return new StringType("");
    }

    public boolean isLongText(ILabResult localObject) {
        String resultValue = localObject.getResult().trim().replaceAll("[()]", "");
        String resultComment = localObject.getComment();
        return resultValue != null && localObject.getItem().getTyp() == LabItemTyp.TEXT && resultValue.equalsIgnoreCase("text") && resultComment != null && !resultComment.isEmpty();
    }

    private static Optional<Quantity.QuantityComparator> getComparator(String result) {
        if (result.startsWith("<=")) {
            return Optional.of(Quantity.QuantityComparator.LESS_OR_EQUAL);
        }
        if (result.startsWith("<")) {
            return Optional.of(Quantity.QuantityComparator.LESS_THAN);
        }
        if (result.startsWith(">=")) {
            return Optional.of(Quantity.QuantityComparator.GREATER_OR_EQUAL);
        }
        if (result.startsWith(">")) {
            return Optional.of(Quantity.QuantityComparator.GREATER_THAN);
        }
        return Optional.empty();
    }

    private static Optional<Double> getNumericValue(String result) {
        Double ret = null;
        result = result.replaceAll("[\\*!,<>=]", "").replaceAll(" ", "");
        try {
            ret = Double.parseDouble(result);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return Optional.ofNullable(ret);
    }

    public List<Observation.ObservationReferenceRangeComponent> getReferenceComponents(ILabResult localObject) {
        String localRef = null;
        if (localObject.getPatient().getGender() == Gender.FEMALE) {
            localRef = localObject.getReferenceFemale();
            if (localRef == null) {
                localRef = localObject.getItem().getReferenceFemale();
            }
        } else {
            localRef = localObject.getReferenceMale();
            if (localRef == null) {
                localRef = localObject.getItem().getReferenceMale();
            }
        }
        if (localRef != null) {
            Observation.ObservationReferenceRangeComponent comp = new Observation.ObservationReferenceRangeComponent();
            Optional<Quantity> lowRef = this.getReferenceLow(localRef);
            Optional<Quantity> highRef = this.getReferenceHigh(localRef);
            if (lowRef.isPresent() || highRef.isPresent()) {
                lowRef.ifPresent(value -> {
                    Observation.ObservationReferenceRangeComponent observationReferenceRangeComponent2 = comp.setLow(value);
                });
                highRef.ifPresent(value -> {
                    Observation.ObservationReferenceRangeComponent observationReferenceRangeComponent2 = comp.setHigh(value);
                });
            } else {
                comp.setText(localRef);
            }
            return Collections.singletonList(comp);
        }
        return Collections.emptyList();
    }

    private Optional<Quantity> getReferenceLow(String localRef) {
        String[] range = localRef.split("\\s*-\\s*");
        if (range.length == 2) {
            try {
                double lower = Double.parseDouble(range[0]);
                return Optional.of(new SimpleQuantity().setValue(lower));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return Optional.empty();
    }

    private Optional<Quantity> getReferenceHigh(String localRef) {
        String[] range = localRef.split("\\s*-\\s*");
        if (range.length == 2) {
            try {
                double high = Double.parseDouble(range[1]);
                return Optional.of(new SimpleQuantity().setValue(high));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return Optional.empty();
    }

    public CodeableConcept getCodeableConcept(ILabResult localObject) {
        CodeableConcept ret = new CodeableConcept();
        ILabItem item = localObject.getItem();
        ret.addCoding(new Coding(CodingSystem.ELEXIS_LOCAL_LABORATORY.getSystem(), item.getCode(), item.getName()));
        ret.addCoding(new Coding(CodingSystem.ELEXIS_LOCAL_LABORATORY_GROUP.getSystem(), item.getGroup() + "/" + item.getPriority(), item.getGroup()));
        return ret;
    }

    public List<Annotation> getNote(ILabResult localObject) {
        if (!this.isLongText(localObject)) {
            Annotation annotation = new Annotation();
            annotation.setText(localObject.getComment());
            return Collections.singletonList(annotation);
        }
        return Collections.emptyList();
    }

    public List<CodeableConcept> getInterpretationConcept(ILabResult localObject) {
        CodeableConcept ret = new CodeableConcept();
        if (localObject.isPathologic()) {
            ret.addCoding(new Coding("http://hl7.org/fhir/ValueSet/observation-interpretation", "A", "Abnormal"));
        } else {
            ret.addCoding(new Coding("http://hl7.org/fhir/ValueSet/observation-interpretation", "N", "Normal"));
        }
        return Collections.singletonList(ret);
    }

    public Observation.ObservationStatus getStatus(ILabResult localObject) {
        return Observation.ObservationStatus.FINAL;
    }
}

