/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.util.fhir.transformer;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.rest.api.SummaryEnum;
import ch.elexis.core.findings.util.fhir.IFhirTransformer;
import ch.elexis.core.findings.util.fhir.transformer.FhirTransformerCache;
import ch.elexis.core.findings.util.fhir.transformer.mapper.IReminderTaskAttributeMapper;
import ch.elexis.core.model.IReminder;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.IModelService;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import org.hl7.fhir.r4.model.Task;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.LoggerFactory;

@Component
public class TaskReminderTransformer
implements IFhirTransformer<Task, IReminder> {
    @Reference(target="(service.model.name=ch.elexis.core.model)")
    private IModelService coreModelService;
    private IReminderTaskAttributeMapper attributeMapper;
    private FhirTransformerCache<Task> cache;

    @Activate
    private void activate() {
        this.attributeMapper = new IReminderTaskAttributeMapper(this.coreModelService);
        this.cache = new FhirTransformerCache();
    }

    @Override
    public boolean matchesTypes(Class<?> fhirClazz, Class<?> localClazz) {
        return Task.class.equals(fhirClazz) && IReminder.class.equals(localClazz);
    }

    @Override
    public Optional<IReminder> getLocalObject(Task fhirObject) {
        String id = fhirObject.getIdElement().getIdPart();
        if (id != null && !id.isEmpty()) {
            return this.coreModelService.load(id, IReminder.class);
        }
        return Optional.empty();
    }

    @Override
    public Optional<IReminder> createLocalObject(Task fhirObject) {
        if (!fhirObject.hasStatus()) {
            LoggerFactory.getLogger(this.getClass()).warn("Create Task failed, has no status set.");
            return Optional.empty();
        }
        IReminder create = (IReminder)this.coreModelService.create(IReminder.class);
        this.attributeMapper.fhirToElexis(fhirObject, create);
        this.coreModelService.save((Identifiable)create);
        return Optional.of(create);
    }

    @Override
    public Optional<Task> getFhirObject(final IReminder localObject, final SummaryEnum summaryEnum, final Set<Include> includes) {
        return this.cache.get((Identifiable)localObject, summaryEnum, includes, new Callable<Task>(){

            @Override
            public Task call() throws Exception {
                Task ret = new Task();
                TaskReminderTransformer.this.attributeMapper.elexisToFhir(localObject, ret, summaryEnum, (Set<Include>)includes);
                return ret;
            }
        });
    }

    @Override
    public Optional<IReminder> updateLocalObject(Task fhirObject, IReminder localObject) {
        this.cache.invalidate((Identifiable)localObject);
        this.attributeMapper.fhirToElexis(fhirObject, localObject);
        this.coreModelService.save((Identifiable)localObject);
        return Optional.of(localObject);
    }
}

