/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.util.fhir.transformer;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.primitive.IdDt;
import ca.uhn.fhir.rest.api.SummaryEnum;
import ch.elexis.core.findings.util.fhir.IFhirTransformer;
import ch.elexis.core.findings.util.fhir.transformer.helper.FhirUtil;
import ch.elexis.core.findings.util.fhir.transformer.mapper.IInvoiceInvoiceAttributeMapper;
import ch.elexis.core.model.IBilled;
import ch.elexis.core.model.IEncounter;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.IModelService;
import ch.rgw.tools.Money;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.r4.model.ChargeItem;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.Invoice;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component
public class InvoiceIEncounterTransformer
implements IFhirTransformer<Invoice, IEncounter> {
    @Reference(target="(service.model.name=ch.elexis.core.model)")
    private IModelService coreModelService;
    @Reference(target="(transformer.id=ChargeItem.IBilled)")
    private IFhirTransformer<ChargeItem, IBilled> chargeItemTransformer;
    private IInvoiceInvoiceAttributeMapper attributeMapper;
    private final CodeableConcept TYPE_VIRTUAL = new CodeableConcept(new Coding("", "encounter-only", ""));

    @Activate
    public void activate() {
        this.attributeMapper = new IInvoiceInvoiceAttributeMapper(this.chargeItemTransformer);
    }

    @Override
    public Optional<Invoice> getFhirObject(IEncounter localObject, SummaryEnum summaryEnum, Set<Include> includes) {
        Invoice invoice = new Invoice();
        invoice.setId((IIdType)new IdDt("Invoice", "virtual." + localObject.getId()));
        invoice.setStatus(Invoice.InvoiceStatus.DRAFT);
        invoice.setType(this.TYPE_VIRTUAL);
        invoice.setSubject(FhirUtil.getReference((Identifiable)localObject.getPatient()));
        Money sumTotal = new Money(0);
        List billed = localObject.getBilled();
        for (IBilled iBilled : billed) {
            invoice.addLineItem(this.attributeMapper.toInvoiceLineItemComponent(iBilled, includes, sumTotal));
        }
        invoice.setTotalGross(FhirUtil.toFhir(sumTotal));
        return Optional.of(invoice);
    }

    @Override
    public Optional<IEncounter> getLocalObject(Invoice fhirObject) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Optional<IEncounter> updateLocalObject(Invoice fhirObject, IEncounter localObject) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Optional<IEncounter> createLocalObject(Invoice fhirObject) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean matchesTypes(Class<?> fhirClazz, Class<?> localClazz) {
        return Invoice.class.equals(fhirClazz) && IEncounter.class.equals(localClazz);
    }
}

