/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.util.fhir.transformer;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.rest.api.SummaryEnum;
import ch.elexis.core.findings.util.fhir.IFhirTransformer;
import ch.elexis.core.findings.util.fhir.transformer.helper.FhirUtil;
import ch.elexis.core.findings.util.fhir.transformer.mapper.ISickCertificateConditionAttributeMapper;
import ch.elexis.core.model.ISickCertificate;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.IModelService;
import java.util.Optional;
import java.util.Set;
import org.hl7.fhir.r4.model.Condition;
import org.hl7.fhir.r4.model.DomainResource;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"transformer.id=Condition.ISickCertificate"})
public class ConditionISickCertificateTransformer
implements IFhirTransformer<Condition, ISickCertificate> {
    @Reference(target="(service.model.name=ch.elexis.core.model)")
    private IModelService coreModelService;
    private ISickCertificateConditionAttributeMapper attributeMapper = new ISickCertificateConditionAttributeMapper();

    @Override
    public Optional<Condition> getFhirObject(ISickCertificate localObject, SummaryEnum summaryEnum, Set<Include> includes) {
        Condition condition = new Condition();
        this.attributeMapper.elexisToFhir(localObject, condition, summaryEnum, includes);
        FhirUtil.setVersionedIdPartLastUpdatedMeta(Condition.class, (DomainResource)condition, (Identifiable)localObject);
        return Optional.of(condition);
    }

    @Override
    public Optional<ISickCertificate> getLocalObject(Condition fhirObject) {
        Optional<String> localId;
        if (fhirObject != null && fhirObject.getId() != null && (localId = FhirUtil.getLocalId(fhirObject.getId())).isPresent()) {
            return this.coreModelService.load(localId.get(), ISickCertificate.class);
        }
        return Optional.empty();
    }

    @Override
    public Optional<ISickCertificate> updateLocalObject(Condition fhirObject, ISickCertificate localObject) {
        this.attributeMapper.fhirToElexis(fhirObject, localObject);
        this.coreModelService.save((Identifiable)localObject);
        return Optional.of(localObject);
    }

    @Override
    public Optional<ISickCertificate> createLocalObject(Condition fhirObject) {
        ISickCertificate create = (ISickCertificate)this.coreModelService.create(ISickCertificate.class);
        this.attributeMapper.fhirToElexis(fhirObject, create);
        this.coreModelService.save((Identifiable)create);
        return Optional.of(create);
    }

    @Override
    public boolean matchesTypes(Class<?> fhirClazz, Class<?> localClazz) {
        return Condition.class.equals(fhirClazz) && ISickCertificate.class.equals(localClazz);
    }
}

