/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.util.fhir.transformer;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.rest.api.SummaryEnum;
import ch.elexis.core.findings.ICondition;
import ch.elexis.core.findings.IFinding;
import ch.elexis.core.findings.IFindingsService;
import ch.elexis.core.findings.util.ModelUtil;
import ch.elexis.core.findings.util.fhir.IFhirTransformer;
import ch.elexis.core.findings.util.fhir.accessor.ConditionAccessor;
import ch.elexis.core.findings.util.fhir.transformer.helper.FhirUtil;
import ch.elexis.core.findings.util.fhir.transformer.helper.FindingsContentHelper;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.IModelService;
import java.util.Optional;
import java.util.Set;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.r4.model.BaseResource;
import org.hl7.fhir.r4.model.Condition;
import org.hl7.fhir.r4.model.DomainResource;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component
public class ConditionIConditionTransformer
implements IFhirTransformer<Condition, ICondition> {
    @Reference(target="(service.model.name=ch.elexis.core.model)")
    private IModelService modelService;
    @Reference
    private IFindingsService findingsService;
    private ConditionAccessor accessor = new ConditionAccessor();
    private FindingsContentHelper contentHelper = new FindingsContentHelper();

    @Override
    public Optional<Condition> getFhirObject(ICondition localObject, SummaryEnum summaryEnum, Set<Include> includes) {
        Optional<IBaseResource> resource = this.contentHelper.getResource((IFinding)localObject);
        if (resource.isPresent()) {
            Condition fhirObject = (Condition)resource.get();
            FhirUtil.setVersionedIdPartLastUpdatedMeta(Condition.class, (DomainResource)fhirObject, (Identifiable)localObject);
            return Optional.of(fhirObject);
        }
        return Optional.empty();
    }

    @Override
    public Optional<ICondition> getLocalObject(Condition fhirObject) {
        Optional existing;
        if (fhirObject != null && fhirObject.getId() != null && (existing = this.findingsService.findById(FhirUtil.getLocalId(fhirObject.getId()).orElse(""), ICondition.class)).isPresent()) {
            return Optional.of((ICondition)existing.get());
        }
        return Optional.empty();
    }

    @Override
    public Optional<ICondition> updateLocalObject(Condition fhirObject, ICondition localObject) {
        Optional<String> fhirText = ModelUtil.getNarrativeAsString(fhirObject.getText());
        if (fhirText.isPresent()) {
            localObject.setText(fhirText.get());
        } else {
            localObject.setText("");
        }
        localObject.setStatus(this.accessor.getStatus((DomainResource)fhirObject));
        localObject.setStart(this.accessor.getStart((DomainResource)fhirObject).orElse(""));
        localObject.setEnd(this.accessor.getEnd((DomainResource)fhirObject).orElse(""));
        this.findingsService.saveFinding((IFinding)localObject);
        return Optional.of(localObject);
    }

    @Override
    public Optional<ICondition> createLocalObject(Condition fhirObject) {
        ICondition iCondition = (ICondition)this.findingsService.create(ICondition.class);
        this.contentHelper.setResource((BaseResource)fhirObject, (IFinding)iCondition);
        if (fhirObject.getSubject() != null && fhirObject.getSubject().hasReference()) {
            String id = fhirObject.getSubject().getReferenceElement().getIdPart();
            Optional patient = this.modelService.load(id, IPatient.class);
            patient.ifPresent(k -> iCondition.setPatientId(id));
        }
        this.findingsService.saveFinding((IFinding)iCondition);
        return Optional.of(iCondition);
    }

    @Override
    public boolean matchesTypes(Class<?> fhirClazz, Class<?> localClazz) {
        return Condition.class.equals(fhirClazz) && ICondition.class.equals(localClazz);
    }
}

