/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.util.fhir.transformer.mapper;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.primitive.IdDt;
import ca.uhn.fhir.rest.api.SummaryEnum;
import ch.elexis.core.findings.codes.CodingSystem;
import ch.elexis.core.findings.util.fhir.transformer.helper.FhirUtil;
import ch.elexis.core.findings.util.fhir.transformer.helper.ICoverageHelper;
import ch.elexis.core.findings.util.fhir.transformer.mapper.IdentifiableDomainResourceAttributeMapper;
import ch.elexis.core.model.BillingSystem;
import ch.elexis.core.model.IBillingSystem;
import ch.elexis.core.model.ICoverage;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.IModelService;
import java.time.LocalDate;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Coverage;
import org.hl7.fhir.r4.model.DomainResource;
import org.hl7.fhir.r4.model.Period;

public class ICoverageCoverageAttributeMapper
implements IdentifiableDomainResourceAttributeMapper<ICoverage, Coverage> {
    private IModelService coreModelService;
    private ICoverageHelper coverageHelper = new ICoverageHelper();

    public ICoverageCoverageAttributeMapper(IModelService coreModelService) {
        this.coreModelService = coreModelService;
    }

    @Override
    public void elexisToFhir(ICoverage source, Coverage target, SummaryEnum summaryEnum, Set<Include> includes) {
        target.setId((IIdType)new IdDt(Coverage.class.getSimpleName(), source.getId()));
        this.mapMetaData((Identifiable)source, (DomainResource)target);
        if (SummaryEnum.DATA != summaryEnum) {
            this.mapNarrative((Identifiable)source, (DomainResource)target);
        }
        if (SummaryEnum.TEXT == summaryEnum || SummaryEnum.COUNT == summaryEnum) {
            return;
        }
        this.coverageHelper.setNarrative((DomainResource)target, this.coverageHelper.getFallText(source));
        CodeableConcept type = new CodeableConcept();
        this.coverageHelper.getType(source).ifPresent(arg_0 -> ((CodeableConcept)type).addCoding(arg_0));
        this.coverageHelper.getReason(source).ifPresent(arg_0 -> ((CodeableConcept)type).addCoding(arg_0));
        this.coverageHelper.getAccidentDate(source).ifPresent(arg_0 -> ((CodeableConcept)type).addCoding(arg_0));
        target.setType(type);
        this.coverageHelper.getInsuranceNumber(source).ifPresent(arg_0 -> ((Coverage)target).addIdentifier(arg_0));
        target.setPeriod(this.coverageHelper.getPeriod(source));
        target.setPolicyHolder(this.coverageHelper.getPolicyHolderReference(source));
        target.setPayor(Collections.singletonList(this.coverageHelper.getPayor(source)));
        target.setBeneficiary(this.coverageHelper.getBeneficiaryReference(source));
        target.setDependent(this.coverageHelper.getDependent(source));
        target.setStatus(source.isOpen() ? Coverage.CoverageStatus.ACTIVE : Coverage.CoverageStatus.CANCELLED);
    }

    @Override
    public void fhirToElexis(Coverage source, ICoverage target) {
        Optional<String> type;
        String dependent = source.getDependent();
        if (dependent != null) {
            this.coverageHelper.setDependent(target, source.getDependent());
        }
        if ((type = this.coverageHelper.getType(source)).isPresent()) {
            target.setBillingSystem((IBillingSystem)new BillingSystem(type.get(), null));
        }
        FhirUtil.getCodeFromCodingList(CodingSystem.ELEXIS_COVERAGE_REASON.getSystem(), source.getType().getCoding()).ifPresent(arg_0 -> ((ICoverage)target).setReason(arg_0));
        this.coverageHelper.setInsuranceNumber(source, target);
        Period period = source.getPeriod();
        if (period != null && period.getStart() != null) {
            this.coverageHelper.setPeriod(target, source.getPeriod());
        } else {
            target.setDateFrom(LocalDate.now());
            target.setDateTo(null);
        }
        this.coverageHelper.getPolicyHolderByReference(this.coreModelService, source.getPolicyHolder()).ifPresent(guarantor -> target.setGuarantor(guarantor));
        this.coverageHelper.getPayorByReference(this.coreModelService, source.getPayorFirstRep()).ifPresent(payor -> target.setCostBearer(payor));
    }
}

